/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.IOException;
import java.io.InputStream;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileAccessCardService;

public class CardFileInputStream
extends InputStream {
    private CardFile cf;
    private FileAccessCardService fileSystem;
    private int filePointer;
    private boolean open;

    public CardFileInputStream(CardFile file) throws IOException, CardTerminalException, CardIOException {
        this.cf = file;
        this.fileSystem = file.getFileAccessService();
        if (!this.cf.isTransparent()) {
            throw new CardIOException("not transparent: " + file.getPath());
        }
        this.filePointer = 0;
        this.open = true;
    }

    @Override
    public int available() throws IOException, CardTerminalException {
        return 0;
    }

    @Override
    public void close() throws IOException, CardTerminalException {
        if (this.open) {
            this.open = false;
        }
        this.fileSystem = null;
        this.cf = null;
    }

    @Override
    public int read() throws IOException, CardTerminalException {
        byte[] data = this.fileSystem.read(this.cf.getPath(), this.filePointer, 1);
        ++this.filePointer;
        return data == null ? -1 : data[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException, CardTerminalException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException, CardTerminalException {
        byte[] data = this.fileSystem.read(this.cf.getPath(), this.filePointer, length);
        if (data == null) {
            return -1;
        }
        System.arraycopy(data, 0, b, offset, data.length);
        this.filePointer += data.length;
        return data.length;
    }

    @Override
    public long skip(long n) throws IOException, CardTerminalException {
        long oldFilePointer = this.filePointer;
        long newFilePointer = oldFilePointer + n;
        long len = this.cf.getLength();
        if (newFilePointer > len) {
            newFilePointer = len;
        }
        this.filePointer = (int)newFilePointer;
        return newFilePointer - oldFilePointer;
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

