/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.UnsupportedEncodingException;
import opencard.core.OpenCardConstants;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardIOException;

public class CardFileAppID
extends CardFilePathComponent
implements OpenCardConstants {
    private boolean asByteSequence = false;

    public CardFileAppID(String comp) {
        super(comp);
        if (comp.startsWith("#")) {
            this.asByteSequence = true;
            if ((comp.length() - 1) % 2 != 0) {
                throw new IllegalArgumentException("odd number of characters");
            }
        }
    }

    public byte[] toByteArray() {
        if (!this.asByteSequence) {
            try {
                return this.comp.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new CardIOException("cannot retrieve byte representation for \"" + this.comp + "\" via 8859_1encoding");
            }
        }
        int bytes = (this.comp.length() - 1) / 2;
        byte[] ba = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            ba[i] = (byte)(Integer.parseInt(this.comp.substring(i * 2 + 1, i * 2 + 3), 16) & 0xFF);
        }
        return ba;
    }

    @Override
    public boolean equals(Object comp) {
        byte[] b;
        if (!(comp instanceof CardFileAppID)) {
            return false;
        }
        byte[] a = this.toByteArray();
        if (a.length != (b = ((CardFileAppID)comp).toByteArray()).length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        byte[] a = this.toByteArray();
        int hash = 0;
        for (int i = 0; i < a.length; ++i) {
            hash = ((hash & 0xFF000000) >>> 21) + (hash << 8) + a[i];
        }
        return hash;
    }
}

