/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.FileNotFoundException;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInabilityException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.iso.fs.FileSystemCardService;
import opencard.opt.service.CardServiceObjectNotAvailableException;

public class CardFile
implements CardFileInfo {
    private CardFilePath file_path = null;
    private FileAccessCardService file_access = null;
    private FileSystemCardService file_system = null;
    private CardFile file_parent = null;
    protected CardFileInfo file_info = null;

    public CardFile(FileAccessCardService service) throws FileNotFoundException, OpenCardException {
        this(service.getRoot(), service);
    }

    public CardFile(FileAccessCardService service, CardFilePath abspath) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(abspath), service);
    }

    public CardFile(FileAccessCardService service, String abspath) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(abspath), service);
    }

    public CardFile(CardFile base, CardFilePath relpath) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(base.file_path).append(relpath), base.file_access);
        if (relpath.numberOfComponents() == 1) {
            this.file_parent = base;
        }
    }

    public CardFile(CardFile base, String relpath) throws FileNotFoundException, OpenCardException {
        this(base, new CardFilePath(relpath));
    }

    public CardFile(CardFile base, CardFilePathComponent comp) throws FileNotFoundException, OpenCardException {
        this(new CardFilePath(base.file_path).append(comp), base.file_access);
        this.file_parent = base;
    }

    protected CardFile(CardFilePath path, FileAccessCardService service) throws FileNotFoundException, CardServiceException, CardTerminalException {
        this.file_path = this.resolvePath(path);
        this.file_access = service;
        this.file_parent = null;
        if (service instanceof FileSystemCardService) {
            this.file_system = (FileSystemCardService)service;
        }
        try {
            this.file_info = service.getFileInfo(path);
        }
        catch (CardServiceObjectNotAvailableException ona) {
            throw new FileNotFoundException(path.toString());
        }
    }

    public final CardFilePath getCanonicalPath() {
        return this.file_path;
    }

    public CardFilePath getAbsolutePath() {
        return this.file_path;
    }

    public final CardFilePath getPath() {
        return this.getCanonicalPath();
    }

    public String getName() {
        return this.file_path.tail().toString();
    }

    @Override
    public final short getFileID() {
        return this.file_info.getFileID();
    }

    @Override
    public final boolean isDirectory() {
        return this.file_info.isDirectory();
    }

    public final boolean isFile() {
        return !this.isDirectory();
    }

    public final boolean isDF() {
        return this.isDirectory();
    }

    public final boolean isEF() {
        return this.isFile();
    }

    @Override
    public final boolean isTransparent() {
        return this.file_info.isTransparent();
    }

    @Override
    public final boolean isCyclic() {
        return this.file_info.isCyclic();
    }

    @Override
    public final boolean isVariable() {
        return this.file_info.isVariable();
    }

    @Override
    public final int getLength() {
        return this.file_info.getLength();
    }

    @Override
    public final int getRecordSize() {
        return this.file_info.getRecordSize();
    }

    @Override
    public final byte[] getHeader() {
        return this.file_info.getHeader();
    }

    protected final FileAccessCardService getFileAccessService() {
        return this.file_access;
    }

    protected final FileSystemCardService getFileSystemService() {
        return this.file_system;
    }

    protected CardFilePath resolvePath(CardFilePath path) {
        return path;
    }

    public CardFile getParent() {
        if (this.file_parent == null) {
            CardFilePath parent = new CardFilePath(this.file_path);
            try {
                if (parent.chompTail()) {
                    this.file_parent = new CardFile(this, parent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.file_parent;
    }

    public boolean exists(CardFilePath relpath) {
        CardFilePath path = new CardFilePath(this.file_path);
        path.append(relpath);
        boolean does = false;
        try {
            does = this.file_access.exists(path);
        }
        catch (CardServiceObjectNotAvailableException cardServiceObjectNotAvailableException) {
        }
        catch (OpenCardException openCardException) {
            // empty catch block
        }
        return does;
    }

    public final CardFileInfo getFileInfo() {
        return this.file_info;
    }

    public final void create(byte[] data) throws CardServiceInabilityException, OpenCardException {
        if (this.file_system == null) {
            throw new CardServiceInabilityException("create() requires FileSystemCardService");
        }
        this.file_system.create(this.file_path, data);
    }

    public void delete(CardFilePath relpath) throws CardServiceInabilityException, OpenCardException {
        if (this.file_system == null) {
            throw new CardServiceInabilityException("delete() requires FileSystemCardService");
        }
        CardFilePath path = new CardFilePath(this.file_path);
        path.append(relpath);
        this.file_system.delete(path);
    }

    public int hashCode() {
        return this.file_path.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CardFile ");
        sb.append(this.getAbsolutePath());
        return sb.toString();
    }
}

