/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.emv.mgmt;

import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.mgmt.InvalidAppletInfoException;
import opencard.opt.emv.mgmt.EMVTags;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.util.TLV;

public class EMVAppletInfo
extends AppletInfo
implements EMVTags {
    private Tracer itracer = new Tracer((Object)this, EMVAppletInfo.class);
    protected byte[] prefName = null;
    protected byte[] prioInd = null;
    protected byte[] discrData = null;
    private static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    protected EMVAppletInfo() {
        this.setDomain(new CardFilePath(":3F00"));
    }

    public EMVAppletInfo(AppletID aid, String label) {
        this.setAppletID(aid);
        this.setLabel(label);
    }

    public EMVAppletInfo(TLV info) throws InvalidAppletInfoException {
        this();
        this.fromEMVTLV(info);
    }

    public byte[] getPreferredName() {
        return this.prefName;
    }

    public byte[] getPriority() {
        return this.prioInd;
    }

    public byte[] getDiscretionaryData() {
        return this.discrData;
    }

    public void fromEMVTLV(TLV info) throws InvalidAppletInfoException {
        this.setAppletID(info);
        this.setLabel(info);
        this.setDomain(info);
        this.setPreferredName(info);
        this.setDiscretionaryData(info);
        this.setPriority(info);
    }

    private void setAppletID(TLV info) throws InvalidAppletInfoException {
        TLV tlv = info.findTag(TAG_EMV_ADF_NAME, null);
        if (tlv == null) {
            throw new InvalidAppletInfoException();
        }
        this.setAppletID(new AppletID(tlv.valueAsByteArray()));
    }

    private void setLabel(TLV info) throws InvalidAppletInfoException {
        TLV tlv = info.findTag(TAG_EMV_APP_LABEL, null);
        if (tlv == null) {
            throw new InvalidAppletInfoException();
        }
        this.setLabel(new String(tlv.valueAsByteArray()));
    }

    private void setPreferredName(TLV info) {
        TLV tlv = info.findTag(TAG_EMV_APP_PREF_NAME, null);
        this.prefName = tlv == null ? null : tlv.valueAsByteArray();
    }

    private void setPriority(TLV info) {
        TLV tlv = info.findTag(TAG_EMV_APP_PRIO_IND, null);
        this.prioInd = tlv == null ? null : tlv.valueAsByteArray();
    }

    private void setDiscretionaryData(TLV info) {
        TLV tlv = info.findTag(TAG_EMV_APP_DISCR_DATA, null);
        this.discrData = tlv == null ? null : tlv.valueAsByteArray();
    }

    private void setDomain(TLV info) {
        CardFilePath path = new CardFilePath("#" + EMVAppletInfo.hexify(this.getAppletID().getBytes(), false));
        this.setDomain(path);
    }

    private static String hexify(byte[] data, boolean seperator) {
        if (data == null) {
            return "null";
        }
        StringBuffer out = new StringBuffer(256);
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (seperator && n > 0) {
                out.append(' ');
            }
            out.append(hexChars[data[i] >> 4 & 0xF]);
            out.append(hexChars[data[i] & 0xF]);
            if (++n != 16) continue;
            out.append('\n');
            n = 0;
        }
        return out.toString();
    }

    public TLV toEMVTLV() {
        if (this.aid == null) {
            return null;
        }
        TLV infoTLV = null;
        TLV nameTLV = new TLV(TAG_EMV_ADF_NAME, this.getAppletID().getBytes());
        infoTLV = new TLV(TAG_EMV_APP_TEMPLATE, nameTLV);
        if (this.label != null) {
            TLV labelTLV = new TLV(TAG_EMV_APP_LABEL, this.getLabel().getBytes());
            infoTLV.add(labelTLV);
        }
        if (this.prefName != null) {
            TLV prefNameTLV = new TLV(TAG_EMV_APP_PREF_NAME, this.prefName);
            infoTLV.add(prefNameTLV);
        }
        if (this.getDomain() != null) {
            // empty if block
        }
        if (this.discrData != null) {
            TLV dataTLV = new TLV(TAG_EMV_APP_DISCR_DATA, this.discrData);
            infoTLV.add(dataTLV);
        }
        if (this.prioInd != null) {
            TLV prioIndTLV = new TLV(TAG_EMV_APP_PRIO_IND, this.prioInd);
            infoTLV.add(prioIndTLV);
        }
        this.itracer.info("toEMVTLV", "I have built an app TLV: " + infoTLV.toString());
        return infoTLV;
    }

    @Override
    public String toString() {
        StringBuffer at = new StringBuffer("EMV AppletInfo:\n\t");
        at.append(super.toString());
        if (this.prefName != null) {
            at.append("Preferred Name: ").append(new String(this.prefName)).append("\n\t");
        }
        if (this.prioInd != null) {
            at.append("Priority indicator: ").append(HexString.hexify(this.prioInd)).append("\n\t");
        }
        if (this.discrData != null) {
            at.append("Discretionary data: ").append(this.discrData.toString()).append("\n");
        }
        return at.toString();
    }
}

