/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.emv.mgmt;

import java.util.Vector;
import opencard.core.OpenCardConstants;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;
import opencard.opt.applet.mgmt.AbstractAppletAccessor;
import opencard.opt.applet.mgmt.AppletAccessCardService;
import opencard.opt.applet.mgmt.InvalidAppletInfoException;
import opencard.opt.emv.mgmt.EMVAppletInfo;
import opencard.opt.emv.mgmt.EMVTags;
import opencard.opt.util.TLV;

public class BasicEMVAppletAccess
extends AbstractAppletAccessor
implements AppletAccessCardService,
OpenCardConstants,
EMVTags {
    private Tracer itracer = new Tracer((Object)this, BasicEMVAppletAccess.class);
    public static final byte CLASS = 0;
    public static final byte SELECT_INS = -92;
    public static final byte SELECT_P1 = 0;
    public static final byte SELECT_P2 = 0;
    public static final byte SELECT_LE = 0;
    public static final byte READ_INS = -78;
    public static final byte READ_P2 = 4;
    public static final byte READ_LE = 0;
    public static byte[] DIR_PATH = new byte[]{47, 0};
    public static final int SW_OK = 36864;
    public static final int SW_WRONG_LENGTH = 26368;
    public static final int SW_INCORRECT_INS = 28160;
    public static final int SW_INCORRECT_CLA = 27904;
    public static final int SW_INCORRECT_P1P2 = 27270;
    public static final int SW_INCORRECT_LC = 27271;
    public static final int SW_DATA_CORRUPTED = 25217;
    public static final int SW_INCOMPATIBLE = 27009;
    public static final int SW_NOTSUPPORTED = 27265;
    public static final int SW_FILENOTFOUND = 27266;
    public static final int SW_MFCFILENOTFOUND = 37892;
    public static final int SW_RECORDNOTFOUND = 27267;
    public static final int SW_FILEINVALIDATED = 25219;
    public static final byte SW1_INCORRECT_P1P2 = 106;
    public static final byte SW1_RESPONSE_PENDING = 97;
    public static final byte SW1_INCORRECT_LE = 108;

    @Override
    public void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        this.setApplets(this.internalList(scheduler.getSlotChannel()));
    }

    @Override
    protected Vector internalList(SlotChannel channel) throws CardServiceException {
        Vector<EMVAppletInfo> records = new Vector<EMVAppletInfo>();
        boolean eof = false;
        int i = 0;
        try {
            this.selectDirectory(channel);
            while (!eof) {
                try {
                    byte[] data = this.readRecord(channel, ++i);
                    if (data == null) {
                        eof = true;
                        this.itracer.info("list", "End of EF_DIR has been reached!");
                        continue;
                    }
                    EMVAppletInfo aAppletInfo = new EMVAppletInfo(new TLV(data));
                    records.addElement(aAppletInfo);
                }
                catch (InvalidAppletInfoException iate) {
                    this.itracer.info("list", "Invalid Application Info was ignored!");
                }
            }
        }
        catch (CardTerminalException cte) {
            this.itracer.info("list", "CardTerminalException - abort!");
        }
        return records;
    }

    private void selectDirectory(SlotChannel slotChannel) throws CardTerminalException {
        CommandAPDU select_command = new CommandAPDU(5 + DIR_PATH.length);
        select_command.append((byte)0);
        select_command.append((byte)-92);
        select_command.append((byte)0);
        select_command.append((byte)0);
        select_command.append((byte)DIR_PATH.length);
        select_command.append(DIR_PATH);
        ResponseAPDU select_response = slotChannel.sendAPDU(select_command);
        if (select_response.sw() != 36864) {
            this.itracer.error("list", "error occurred while selecting info information file (" + select_response.sw() + ")");
            this.itracer.error("list", "Command Sent:" + select_command.toString());
            this.itracer.error("list", "Response returned:" + select_response.toString());
            this.traceResponseCode(select_response);
            throw new CardTerminalException();
        }
    }

    private byte[] readRecord(SlotChannel channel, int index) throws CardTerminalException {
        CommandAPDU commmandAPDU = new CommandAPDU(5);
        commmandAPDU.append((byte)0);
        commmandAPDU.append((byte)-78);
        commmandAPDU.append((byte)index);
        commmandAPDU.append((byte)4);
        commmandAPDU.append((byte)0);
        ResponseAPDU response = channel.sendAPDU(commmandAPDU);
        if (response != null && response.sw() == 36864) {
            return response.data();
        }
        this.itracer.debug("list", "Command Sent:" + commmandAPDU.toString());
        this.itracer.debug("list", "Response returned:" + response.toString());
        if (response.sw() != 36864) {
            this.itracer.debug("list", "Error reading EF_DIR! (" + response.sw() + ")");
            this.traceResponseCode(response);
        } else {
            this.itracer.debug("list", "No data returned from EF_DIR!");
        }
        return null;
    }

    private void traceResponseCode(ResponseAPDU response) {
        if (response.sw() == 27266 || response.sw() == 37892) {
            this.itracer.debug("list", "File not found");
        } else if (response.sw() == 26368) {
            this.itracer.debug("list", "Wrong length specified");
        } else if (response.sw() == 28160) {
            this.itracer.debug("list", "Invalid Instruction Byte");
        } else if (response.sw() == 27904) {
            this.itracer.debug("list", "Invalid Class Byte");
        } else if (response.sw() == 27271) {
            this.itracer.debug("list", "Wrong command length specified");
        } else if (response.sw() == 25217) {
            this.itracer.debug("list", "Returned data corrupted");
        } else if (response.sw() == 27009) {
            this.itracer.debug("list", "Record File incompatible with file struccture");
        } else if (response.sw() == 27265) {
            this.itracer.debug("list", "command not supported");
        } else if (response.sw() == 27266) {
            this.itracer.debug("list", "File not found");
        } else if (response.sw() == 27267) {
            this.itracer.debug("list", "Record not found");
        } else if (response.sw() == 25219) {
            this.itracer.debug("list", "File is invalidated");
        }
        if (response.sw1() == 106) {
            this.itracer.debug("list", "Directory File not found on this card");
        } else if (response.sw1() == 97) {
            this.itracer.debug("list", "Response from Card is pending");
        } else if (response.sw1() == 108) {
            this.itracer.debug("list", "Wrong expected length specified");
        }
    }
}

