/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.database;

import opencard.core.terminal.ResponseAPDU;
import opencard.opt.database.DatabaseCardService;
import opencard.opt.database.WrongIdentifierSyntaxException;

public class DataObject
implements DatabaseCardService.Constants {
    public static final char INHIBITOR = '/';
    public static final char SEPARATOR = ',';

    protected static void isIdentifier(String s) throws WrongIdentifierSyntaxException {
        boolean b = true;
        if (s.charAt(0) == '_') {
            b = false;
        } else {
            for (int i = 0; i < s.length() && b; ++i) {
                if (Character.isUpperCase(s.charAt(i)) && Character.isLetter(s.charAt(i)) || Character.isDigit(s.charAt(i)) || s.charAt(i) == '_') continue;
                b = false;
            }
        }
        if (!b) {
            throw new WrongIdentifierSyntaxException(s);
        }
    }

    protected static void isDictionaryIdentifier(String s) throws WrongIdentifierSyntaxException {
        DataObject.isIdentifier(s);
        if (s.length() > 6) {
            throw new WrongIdentifierSyntaxException(s);
        }
    }

    protected static boolean isOperator(char c) {
        return c == '<' || c == '>' || c == '=' || c == '!';
    }

    protected static byte parsePrivilege(String priv) {
        byte inter = 0;
        if ((priv = priv.toUpperCase()).indexOf("A") > -1) {
            return 79;
        }
        if (priv.indexOf("I") > -1) {
            inter = (byte)(inter | 0x41);
        }
        if (priv.indexOf("S") > -1) {
            inter = (byte)(inter | 0x42);
        }
        if (priv.indexOf("U") > -1) {
            inter = (byte)(inter | 0x44);
        }
        if (priv.indexOf("D") > -1) {
            inter = (byte)(inter | 0x48);
        }
        return inter;
    }

    protected static byte operator(String condition) {
        condition = (String)condition + " ";
        char a = ((String)condition).charAt(0);
        char b = ((String)condition).charAt(1);
        switch (a) {
            case '<': {
                switch (b) {
                    case '=': {
                        return 76;
                    }
                }
                return 60;
            }
            case '>': {
                switch (b) {
                    case '=': {
                        return 71;
                    }
                }
                return 62;
            }
            case '=': {
                return 61;
            }
            case '!': {
                if (b != '=') break;
                return 35;
            }
        }
        return 0;
    }

    protected static String[] dictionaryResponseToString(char systemTableType, ResponseAPDU resp) {
        byte[] t = resp.data();
        if (systemTableType == 'U') {
            int i;
            char c = DataObject.hexToChar(t[1]);
            String[] tmp = new String[4];
            int l = t[2] + 3;
            switch (c) {
                case 'A': {
                    tmp[0] = "DB_O";
                }
                case 'E': {
                    tmp[0] = "DBBO";
                }
                case 'U': {
                    tmp[0] = "DBBU";
                }
            }
            tmp[1] = "";
            for (i = 3; i < l; ++i) {
                tmp[1] = tmp[1] + DataObject.hexToChar(t[i]);
            }
            int m = t[l++] + l;
            tmp[2] = "";
            for (i = l; i < m; ++i) {
                tmp[2] = tmp[2] + DataObject.hexToChar(t[i]);
            }
            tmp[3] = "";
            l = t[++m] + m;
            for (i = ++m; i < l; ++i) {
                tmp[3] = tmp[3] + DataObject.hexToChar(t[i]);
            }
            return tmp;
        }
        if (systemTableType == 'P') {
            int i;
            String[] tmp = new String[4];
            int l = t[2] + 3;
            tmp[0] = "" + DataObject.hexToChar(t[1]);
            tmp[1] = "";
            for (i = 3; i < l; ++i) {
                tmp[1] = tmp[1] + DataObject.hexToChar(t[i]);
            }
            int m = t[l++] + l;
            tmp[2] = "";
            for (i = l; i < m; ++i) {
                tmp[2] = tmp[2] + DataObject.hexToChar(t[i]);
            }
            tmp[3] = "";
            l = t[m++] + m;
            for (i = m; i < l; ++i) {
                tmp[3] = tmp[3] + DataObject.hexToChar(t[i]);
            }
            return tmp;
        }
        if (systemTableType == 'O') {
            if (resp.data()[0] == 3) {
                int i;
                String[] tmp = new String[19];
                int l = t[2] + 3;
                tmp[0] = "VIEW";
                tmp[1] = "";
                for (i = 3; i < l; ++i) {
                    tmp[1] = tmp[1] + DataObject.hexToChar(t[i]);
                }
                tmp[2] = "";
                for (i = ++l; i < t.length; ++i) {
                    tmp[2] = tmp[2] + DataObject.hexToChar(t[i]);
                }
                for (i = 3; i < 19; ++i) {
                    tmp[i] = "";
                }
                return tmp;
            }
            if (resp.data()[0] == 5) {
                int i;
                String[] tmp = new String[19];
                char c = DataObject.hexToChar(t[1]);
                switch (c) {
                    case 'V': {
                        tmp[0] = "VIEW";
                    }
                    case 'T': {
                        tmp[0] = "TABLE";
                    }
                }
                int l = t[2] + 3;
                tmp[1] = "";
                for (i = 3; i < l; ++i) {
                    tmp[1] = tmp[1] + DataObject.hexToChar(t[i]);
                }
                tmp[2] = "";
                int m = l + t[l++] + 1;
                for (i = l; i < m; ++i) {
                    tmp[2] = tmp[2] + DataObject.hexToChar(t[i]);
                }
                tmp[3] = "";
                l = m + t[m] + 1;
                for (i = m; i < l; ++i) {
                    tmp[3] = tmp[3] + DataObject.hexToChar(t[i]);
                }
                int n = t[l++];
                for (i = 0; i < n; ++i) {
                    tmp[i + 3] = "";
                    m = t[l++] + l;
                    for (int k = l; k < m; ++k) {
                        int n2 = i + 3;
                        tmp[n2] = tmp[n2] + DataObject.hexToChar(t[k]);
                    }
                    l = m;
                }
                for (i = m + 3; i < 19; ++i) {
                    tmp[i] = "";
                }
                return tmp;
            }
        }
        return null;
    }

    protected static String[] responseToString(ResponseAPDU resp) {
        int i;
        byte[] t = resp.data();
        String[] resparse = new String[t[0]];
        int j = 0;
        byte p = (byte)(t[1] + 2);
        for (i = 0; i < t[0]; i = (int)((byte)(i + 1))) {
            resparse[i] = "";
        }
        for (i = 2; i < t.length; i = (int)((byte)(i + 1))) {
            if (i != p) {
                int n = j;
                resparse[n] = resparse[n] + DataObject.hexToChar(t[i]);
                continue;
            }
            j = (byte)(j + 1);
            p = (byte)(p + (byte)(t[i] + 1));
        }
        return resparse;
    }

    protected static String[] parseString(String s) {
        int i = 0;
        int j = 0;
        String[] tmp = new String[s.length()];
        Object s_temp = "";
        if ("".equals(s)) {
            return new String[0];
        }
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '/') {
                if (i >= s.length() - 1) continue;
                s_temp = (String)s_temp + s.charAt(++i);
                continue;
            }
            if (s.charAt(i) == ',') {
                tmp[j++] = s_temp;
                s_temp = "";
                continue;
            }
            s_temp = (String)s_temp + s.charAt(i);
        }
        tmp[j] = s_temp;
        String[] returnString = new String[++j];
        for (i = 0; i < j; ++i) {
            returnString[i] = tmp[i];
        }
        return returnString;
    }

    protected static byte charToHex(char c) {
        return (byte)((byte)(c - 32) + 32);
    }

    protected static char hexToChar(byte b) {
        return (char)((char)(b - 32) + 32);
    }

    public static byte[] bodyAPDU(String c) {
        byte[] command = new byte[c.length() + 1];
        command[0] = (byte)c.length();
        for (int i = 0; i < c.length(); ++i) {
            command[i + 1] = DataObject.charToHex(c.charAt(i));
        }
        return command;
    }

    public static byte[] bodyAPDU(byte[] b) {
        byte[] command = new byte[b.length + 1];
        command[0] = (byte)b.length;
        for (int i = 0; i < b.length; ++i) {
            command[i + 1] = b[i];
        }
        return command;
    }

    public static byte[] headerAPDU(byte CLA, byte INS, byte P1, byte P2) {
        byte[] command = new byte[]{CLA, INS, P1, P2, 0};
        return command;
    }

    public static byte[] headerAPDU(byte CLA, byte INS, byte P1, byte P2, byte lc_size) {
        if (lc_size > 0) {
            byte[] command1 = new byte[]{CLA, INS, P1, P2, lc_size};
            return command1;
        }
        byte[] command2 = new byte[]{CLA, INS, P1, P2};
        return command2;
    }
}

