/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.database;

import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.database.CommandNotAllowedException;
import opencard.opt.database.DataObject;
import opencard.opt.database.DatabaseCardService;
import opencard.opt.database.EndOfTableReachedException;
import opencard.opt.database.IncorrectParameterInDataFieldException;
import opencard.opt.database.InstructionCodeNotSupportedException;
import opencard.opt.database.MemoryFailureError;
import opencard.opt.database.ObjectAlreadyExistsException;
import opencard.opt.database.OperationNotSupportedException;
import opencard.opt.database.ReferencedObjectNotFoundException;
import opencard.opt.database.RequiredPrecedentCommandNotPerformedException;
import opencard.opt.database.SCQLError;
import opencard.opt.database.SCQLException;
import opencard.opt.database.SecurityAttribute;
import opencard.opt.database.SecurityStatusNotSatisfiedException;
import opencard.opt.database.WrongLengthException;
import opencard.opt.database.WrongLengthLeException;
import opencard.opt.database.WrongParameterException;

public class BasicDatabase
extends CardService
implements DatabaseCardService,
DatabaseCardService.Constants {
    private static Tracer ctracer = new Tracer(BasicDatabase.class);
    protected final int MAX_SIZE = 300;

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
    }

    @Override
    public void createTable(String tableName, String columnsList, byte maxNumberOfRows, SecurityAttribute securityAttribute) throws SCQLException {
        tableName = tableName.toUpperCase();
        DataObject.isIdentifier(tableName);
        String[] col = DataObject.parseString(columnsList.toUpperCase());
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-128));
        cmd.append(DataObject.bodyAPDU(tableName));
        cmd.append((byte)col.length);
        for (int i = 0; i < col.length; ++i) {
            cmd.append(DataObject.bodyAPDU(col[i].trim()));
        }
        if (maxNumberOfRows > 0) {
            cmd.append((byte)1);
            cmd.append(maxNumberOfRows);
        }
        if (securityAttribute != null) {
            cmd.append(securityAttribute.getBytes());
        }
        this.sendAPDU(cmd);
    }

    public void createTable(String tableName, String columnsList, SecurityAttribute securityAttribute) throws SCQLException {
        this.createTable(tableName, columnsList, (byte)0, securityAttribute);
    }

    @Override
    public void createView(String viewName, String tableName, String colunmNames, String conditions, SecurityAttribute securityAttribute) throws SCQLException {
        int i;
        viewName = viewName.toUpperCase();
        DataObject.isIdentifier(viewName);
        tableName = tableName.toUpperCase();
        DataObject.isIdentifier(tableName);
        String[] colname = DataObject.parseString(colunmNames.toUpperCase());
        String[] cond = DataObject.parseString(conditions);
        String[] condcolname = new String[cond.length];
        String[] ope = new String[cond.length];
        for (i = 0; i < cond.length; ++i) {
            int j = 0;
            while (!DataObject.isOperator(cond[i].charAt(j))) {
                ++j;
            }
            condcolname[i] = cond[i].substring(0, j).toUpperCase().trim();
            cond[i] = cond[i].substring(j, cond[i].length()).trim();
            j = DataObject.isOperator(cond[i].charAt(1)) ? 2 : 1;
            ope[i] = cond[i].substring(0, j).trim();
            cond[i] = cond[i].substring(j, cond[i].length()).trim();
        }
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-127));
        cmd.append(DataObject.bodyAPDU(viewName));
        cmd.append(DataObject.bodyAPDU(tableName));
        if (colname[0].trim().equals("*")) {
            cmd.append((byte)0);
        } else {
            cmd.append((byte)colname.length);
            for (i = 0; i < colname.length; ++i) {
                colname[i] = colname[i].trim();
                DataObject.isIdentifier(colname[i]);
                cmd.append(DataObject.bodyAPDU(colname[i]));
            }
        }
        if (condcolname.length > 0) {
            cmd.append((byte)condcolname.length);
            for (i = 0; i < condcolname.length; ++i) {
                cmd.append(DataObject.bodyAPDU(condcolname[i].trim()));
                cmd.append((byte)1);
                cmd.append(DataObject.operator(ope[i].trim()));
                cmd.append(DataObject.bodyAPDU(cond[i]));
            }
        } else {
            cmd.append((byte)0);
        }
        if (securityAttribute != null) {
            cmd.append(securityAttribute.getBytes());
        }
        this.sendAPDU(cmd);
    }

    @Override
    public void createDictionary(String dictionary) throws SCQLException {
        DataObject.isDictionaryIdentifier(dictionary);
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-126));
        cmd.append(DataObject.bodyAPDU(dictionary));
        this.sendAPDU(cmd);
    }

    @Override
    public void dropTable(String tableName) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-125));
        cmd.append(DataObject.bodyAPDU(tableName.toUpperCase()));
        this.sendAPDU(cmd);
    }

    @Override
    public void dropView(String viewName) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-124));
        cmd.append(DataObject.bodyAPDU(viewName.toUpperCase()));
        this.sendAPDU(cmd);
    }

    @Override
    public void grant(String privileges, String objectName, String userID) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-123));
        cmd.append((byte)1);
        cmd.append(DataObject.parsePrivilege(privileges));
        cmd.append(DataObject.bodyAPDU(objectName.toUpperCase()));
        cmd.append(DataObject.bodyAPDU(userID.toUpperCase()));
        this.sendAPDU(cmd);
    }

    @Override
    public void revoke(String privileges, String objectName, String userID) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-122));
        cmd.append((byte)1);
        cmd.append(DataObject.parsePrivilege(privileges));
        cmd.append(DataObject.bodyAPDU(objectName.toUpperCase()));
        cmd.append(DataObject.bodyAPDU(userID.toUpperCase()));
        this.sendAPDU(cmd);
    }

    @Override
    public void declareCursor(String objectName, String columnsName, String conditions) throws SCQLException {
        int i;
        String[] colname = DataObject.parseString(columnsName.toUpperCase());
        String[] cond = DataObject.parseString(conditions);
        String[] condcolname = new String[cond.length];
        String[] ope = new String[cond.length];
        for (i = 0; i < cond.length; ++i) {
            int j = 0;
            while (!DataObject.isOperator(cond[i].charAt(j))) {
                ++j;
            }
            condcolname[i] = cond[i].substring(0, j).toUpperCase();
            cond[i] = cond[i].substring(j, cond[i].length());
            j = DataObject.isOperator(cond[i].charAt(1)) ? 2 : 1;
            ope[i] = cond[i].substring(0, j);
            cond[i] = cond[i].substring(j, cond[i].length());
        }
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-121));
        cmd.append(DataObject.bodyAPDU(objectName.toUpperCase().trim()));
        if (colname[0].trim().equals("*")) {
            cmd.append((byte)0);
        } else {
            cmd.append((byte)colname.length);
            for (i = 0; i < colname.length; ++i) {
                DataObject.isIdentifier(colname[i].trim());
                cmd.append(DataObject.bodyAPDU(colname[i].trim()));
            }
        }
        if (condcolname.length > 0) {
            cmd.append((byte)condcolname.length);
            for (i = 0; i < cond.length; ++i) {
                cmd.append(DataObject.bodyAPDU(condcolname[i].trim()));
                cmd.append((byte)1);
                cmd.append(DataObject.operator(ope[i].trim()));
                cmd.append(DataObject.bodyAPDU(cond[i].trim()));
            }
        } else {
            cmd.append((byte)0);
        }
        this.sendAPDU(cmd);
    }

    @Override
    public void open() throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-120, (byte)0));
        this.sendAPDU(cmd);
    }

    @Override
    public void next() throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-119, (byte)0));
        this.sendAPDU(cmd);
    }

    @Override
    public String[] fetch(byte maxLength) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-118, (byte)0));
        if (maxLength == 0) {
            try {
                this.sendAPDU(cmd);
            }
            catch (WrongLengthLeException e) {
                cmd.append(e.getRightLength());
            }
        } else {
            cmd.append(maxLength);
        }
        return DataObject.responseToString(this.sendAPDU(cmd));
    }

    @Override
    public String[] fetch() throws SCQLException {
        return this.fetch((byte)0);
    }

    @Override
    public String[] fetchNext(byte maxLength) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-117, (byte)0));
        if (maxLength == 0) {
            try {
                this.sendAPDU(cmd);
            }
            catch (WrongLengthLeException e) {
                cmd.append(e.getRightLength());
            }
        } else {
            cmd.append(maxLength);
        }
        return DataObject.responseToString(this.sendAPDU(cmd));
    }

    @Override
    public String[] fetchNext() throws SCQLException {
        return this.fetchNext((byte)0);
    }

    @Override
    public void insert(String tableName, String values) throws SCQLException {
        String[] val = DataObject.parseString(values);
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-116));
        cmd.append(DataObject.bodyAPDU(tableName.toUpperCase()));
        cmd.append((byte)val.length);
        for (int i = 0; i < val.length; ++i) {
            cmd.append(DataObject.bodyAPDU(val[i]));
        }
        this.sendAPDU(cmd);
    }

    @Override
    public void update(String values) throws SCQLException {
        int i;
        String[] col = DataObject.parseString(values);
        String[] val = new String[col.length];
        for (i = 0; i < col.length; ++i) {
            int j = 0;
            while (col[i].charAt(j) != '=') {
                ++j;
            }
            val[i] = col[i].substring(j + 1, col[i].length());
            col[i] = col[i].substring(0, j);
        }
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-115));
        cmd.append((byte)col.length);
        for (i = 0; i < col.length; ++i) {
            cmd.append(DataObject.bodyAPDU(col[i].toUpperCase().trim()));
            cmd.append(DataObject.bodyAPDU(val[i]));
        }
        this.sendAPDU(cmd);
    }

    @Override
    public void delete() throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)16, (byte)0, (byte)-114, (byte)0));
        this.sendAPDU(cmd);
    }

    @Override
    public void begin() throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)18, (byte)0, (byte)-128, (byte)0));
        this.sendAPDU(cmd);
    }

    @Override
    public void commit() throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)18, (byte)0, (byte)-127, (byte)0));
        this.sendAPDU(cmd);
    }

    @Override
    public void rollback() throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)18, (byte)0, (byte)-126, (byte)0));
        this.sendAPDU(cmd);
    }

    @Override
    public void presentUser(String userID, SecurityAttribute securityAttribute) throws SCQLException {
        userID = userID.toUpperCase();
        DataObject.isIdentifier(userID);
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-128));
        if (securityAttribute == null) {
            cmd.append(DataObject.bodyAPDU(userID));
        } else {
            int totalLength = userID.length() + securityAttribute.getDataLength() + 4;
            cmd.append((byte)127);
            cmd.append((byte)33);
            cmd.append((byte)totalLength);
            cmd.append((byte)95);
            cmd.append((byte)32);
            cmd.append(DataObject.bodyAPDU(userID));
            cmd.append(securityAttribute.getBytes());
        }
        this.sendAPDU(cmd);
    }

    @Override
    public void presentUser(String userID) throws SCQLException {
        this.presentUser(userID, null);
    }

    @Override
    public void createUser(String userID, String userProfile, SecurityAttribute securityAttribute) throws SCQLException {
        DataObject.isIdentifier(userID);
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-127));
        cmd.append(DataObject.bodyAPDU(userID));
        if (!userProfile.equals("DBOO") && !userProfile.equals("DBBU")) {
            throw new WrongParameterException(userProfile);
        }
        cmd.append(DataObject.bodyAPDU(userProfile));
        if (securityAttribute != null) {
            cmd.append(securityAttribute.getBytes());
        }
        this.sendAPDU(cmd);
    }

    @Override
    public void deleteUser(String userID) throws SCQLException {
        CommandAPDU cmd = new CommandAPDU(300);
        cmd.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-126));
        cmd.append(DataObject.bodyAPDU(userID.toUpperCase()));
        this.sendAPDU(cmd);
    }

    protected void throwException(ResponseAPDU apdu) throws SCQLException {
        byte sw1 = apdu.sw1();
        byte sw2 = apdu.sw2();
        block0 : switch (sw1) {
            case 108: {
                throw new WrongLengthLeException(sw2);
            }
            case -112: {
                switch (sw2) {
                    case 0: {
                        break block0;
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            case 97: {
                break;
            }
            case 98: {
                switch (sw2) {
                    case -126: {
                        throw new EndOfTableReachedException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            case 101: {
                switch (sw2) {
                    case 0: {
                        throw new SCQLError();
                    }
                    case 98: {
                        throw new MemoryFailureError();
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            case 103: {
                switch (sw2) {
                    case 0: {
                        throw new WrongLengthException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            case 105: {
                switch (sw2) {
                    case 0: {
                        throw new CommandNotAllowedException();
                    }
                    case -126: {
                        throw new SecurityStatusNotSatisfiedException();
                    }
                    case -123: {
                        throw new RequiredPrecedentCommandNotPerformedException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            case 106: {
                switch (sw2) {
                    case -128: {
                        throw new WrongParameterException();
                    }
                    case -127: {
                        throw new IncorrectParameterInDataFieldException();
                    }
                    case -124: {
                        throw new OperationNotSupportedException();
                    }
                    case -120: {
                        throw new ReferencedObjectNotFoundException();
                    }
                    case -119: {
                        throw new ObjectAlreadyExistsException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            case 109: {
                switch (sw2) {
                    case 0: {
                        throw new InstructionCodeNotSupportedException();
                    }
                }
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
            default: {
                throw new SCQLException("Unknown error code : " + (sw1 & 0xFF) + " " + (sw2 & 0xFF));
            }
        }
    }

    protected ResponseAPDU sendAPDU(CommandAPDU cmd) throws SCQLException {
        ResponseAPDU resp = null;
        try {
            this.allocateCardChannel();
            if (cmd.getLength() > 5) {
                cmd.setByte(4, cmd.getLength() - 5 - cmd.getByte(4));
            }
            ctracer.debug("sendAPDU", "-> CommandAPDU : " + cmd.toString());
            resp = this.getCardChannel().sendCommandAPDU(cmd);
            ctracer.debug("sendAPDU", "<- ResponseAPDU : " + resp.toString());
            this.releaseCardChannel();
            this.throwException(resp);
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public static boolean knows(CardID cid, CardServiceScheduler sched) {
        boolean isSCQL = false;
        CommandAPDU presentCommand = null;
        ResponseAPDU presentResponse = null;
        presentCommand = new CommandAPDU(13);
        presentCommand.append(DataObject.headerAPDU((byte)0, (byte)20, (byte)0, (byte)-128, (byte)8));
        presentCommand.append(DataObject.bodyAPDU("PUBLIC"));
        presentCommand.append((byte)0);
        try {
            ctracer.debug("knows", "PRESENT USER CommandAPDU : " + presentCommand.toString());
            presentResponse = sched.getSlotChannel().sendAPDU(presentCommand);
            ctracer.debug("knows", "PRESENT USER ResponseAPDU : " + presentResponse.toString());
        }
        catch (Exception cte) {
            ctracer.info("knows", "Communication Problems During PresentUser.");
        }
        if (presentResponse.sw1() == -112 && presentResponse.sw2() == 0) {
            isSCQL = true;
            ctracer.info("knows", "DATABASE_CARDTYPE card found!");
        } else {
            isSCQL = false;
            ctracer.info("knows", "Not a DATABASE card.");
        }
        return isSCQL;
    }
}

