/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.applet.mgmt;

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.SlotChannel;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.AppletSelector;
import opencard.opt.applet.ISOAppletSelector;
import opencard.opt.applet.mgmt.AppletAccessCardService;

public abstract class AbstractAppletAccessor
extends CardService
implements AppletSelector,
AppletAccessCardService {
    private AppletSelector selector_ = new ISOAppletSelector();
    private Vector applets = null;

    public Vector getApplets() {
        return this.applets;
    }

    public void setApplets(Vector apps) {
        this.applets = apps;
    }

    protected void setAppletSelector(AppletSelector s) {
        this.selector_ = s;
    }

    protected AppletSelector getAppletSelector() {
        return this.selector_;
    }

    @Override
    public AppletInfo selectApplet(CardChannel channel, AppletID appletID) throws CardServiceException, CardTerminalException {
        return this.selector_.selectApplet(channel, appletID);
    }

    protected abstract Vector internalList(SlotChannel var1) throws CardServiceException;

    @Override
    public AppletInfo[] list() throws CardServiceException {
        AppletInfo[] result = null;
        if (this.applets != null) {
            result = new AppletInfo[this.applets.size()];
            Enumeration e = this.applets.elements();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (AppletInfo)e.nextElement();
            }
            return result;
        }
        throw new CardServiceException("Directory information not available");
    }

    @Override
    public AppletInfo getInfo(AppletID aid) throws CardServiceException {
        AppletInfo foundApplet = null;
        if (this.applets != null) {
            Enumeration e = this.applets.elements();
            while (e.hasMoreElements() && foundApplet == null) {
                AppletInfo aAppletInfo = (AppletInfo)e.nextElement();
                if (!aAppletInfo.getAppletID().equals(aid)) continue;
                foundApplet = aAppletInfo;
            }
            return foundApplet;
        }
        throw new CardServiceException("Directory information not available");
    }

    @Override
    public boolean exists(AppletID appletIdentifier) throws CardServiceException {
        return this.getInfo(appletIdentifier) != null;
    }
}

