/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.applet;

import java.util.Hashtable;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletSelector;
import opencard.opt.applet.AppletState;
import opencard.opt.applet.CardState;
import opencard.opt.applet.ISOAppletSelector;

public class BasicAppletCardService
extends CardService {
    private Tracer itracer = new Tracer((Object)this, BasicAppletCardService.class);
    private AppletSelector selector_ = new ISOAppletSelector();
    private static Tracer ctracer = new Tracer(BasicAppletCardService.class);
    private static final AppletID CARD_STATE_AID = new AppletID("SAID".getBytes());

    protected AppletSelector getAppletSelector() {
        return this.selector_;
    }

    protected CardState getCardState(CardChannel channel) {
        return (CardState)((Hashtable)channel.getState()).get(CARD_STATE_AID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, card, blocking);
        ctracer.debug("<init>", "(" + scheduler + "," + card + "," + blocking + ")");
        try {
            this.allocateCardChannel();
            this.itracer.info("initialize", "allocated CardChannel()");
            CardChannel channel = this.getCardChannel();
            Hashtable<AppletID, CardState> channelState = (Hashtable<AppletID, CardState>)channel.getState();
            if (channelState == null) {
                channelState = new Hashtable<AppletID, CardState>();
                channel.setState(channelState);
            }
            if (channelState.get(CARD_STATE_AID) == null) {
                channelState.put(CARD_STATE_AID, new CardState());
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private void selectApplet(CardChannel channel, AppletID appletID) throws CardServiceException, CardTerminalException {
        CardState state = this.getCardState(channel);
        if (state.getSelectedAppletID() == null || !state.getSelectedAppletID().equals(appletID)) {
            ctracer.debug("selectApplet", "selecting " + appletID);
            this.selector_.selectApplet(channel, appletID);
            AppletID previouslySelectedAID = state.setSelectedAppletID(appletID);
            if (previouslySelectedAID != null) {
                Hashtable channelState = (Hashtable)this.getCardChannel().getState();
                ctracer.debug("selectApplet", "previouslySelectedAID = " + previouslySelectedAID);
                ctracer.debug("selectApplet", "channelState = " + channelState);
                AppletState appState = (AppletState)channelState.get(previouslySelectedAID);
                appState.appletDeselected();
            }
        }
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel channel, AppletID appletID, CommandAPDU commandAPDU) throws CardTerminalException, CardServiceException {
        ctracer.debug("sendCommandAPDU(channel,...)", "sending " + commandAPDU + " to <" + appletID + ">");
        this.selectApplet(channel, appletID);
        return channel.sendCommandAPDU(commandAPDU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAPDU sendCommandAPDU(AppletID appletID, CommandAPDU commandAPDU) throws CardTerminalException, CardServiceException {
        ctracer.debug("sendCommandAPDU(...)", "sending " + commandAPDU + " to " + appletID);
        try {
            this.allocateCardChannel();
            ResponseAPDU responseAPDU = this.sendCommandAPDU(this.getCardChannel(), appletID, commandAPDU);
            return responseAPDU;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    protected ResponseAPDU sendVerifiedAPDU(CardChannel channel, AppletID appletID, CommandAPDU verificationAPDU, CHVControl chvControl, int timeout) throws CardServiceException, CardTerminalException {
        this.selectApplet(channel, appletID);
        return channel.sendVerifiedAPDU(verificationAPDU, chvControl, this.getCHVDialog());
    }

    protected void setAppletSelector(AppletSelector s) {
        this.selector_ = s;
    }
}

