/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.applet;

import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.BasicAppletCardService;

public abstract class AppletProxy
extends BasicAppletCardService {
    private AppletID appletID_ = null;
    private static Tracer ctracer = new Tracer(AppletProxy.class);

    public AppletID getAppletID() {
        return this.appletID_;
    }

    protected void initialize(AppletID appletID, CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        ctracer.debug("<init>", "(" + appletID + "," + scheduler + "," + card + "," + blocking + ")");
        super.initialize(scheduler, card, blocking);
        this.appletID_ = appletID;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel channel, CommandAPDU commandAPDU) throws CardTerminalException, CardServiceException {
        return this.sendCommandAPDU(channel, this.appletID_, commandAPDU);
    }

    public ResponseAPDU sendCommandAPDU(CommandAPDU commandAPDU) throws CardTerminalException, CardServiceException {
        return this.sendCommandAPDU(this.appletID_, commandAPDU);
    }

    protected ResponseAPDU sendVerifiedAPDU(CardChannel channel, CommandAPDU verificationAPDU, CHVControl chvControl, int timeout) throws CardServiceException, CardTerminalException {
        return this.sendVerifiedAPDU(channel, this.appletID_, verificationAPDU, chvControl, timeout);
    }
}

