/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import opencard.core.event.TracerEvent;
import opencard.core.event.TracerListener;
import opencard.core.util.SystemAccess;

public class Tracer {
    private static String[] traceList = new String[0];
    private static int[] traceLevels = new int[0];
    private static boolean eventsOnly = false;
    private static boolean condensed = false;
    private static Hashtable tracerListeners = new Hashtable();
    private String myClass;
    private Object me;

    public Tracer(Object _me, String className) {
        this.myClass = className;
        this.me = _me;
    }

    public static void init() {
        try {
            SystemAccess sys = SystemAccess.getSystemAccess();
            String traceProperty = sys.getProperty("OpenCard.trace", "");
            eventsOnly = sys.getBoolean("OpenCard.trace.eventsOnly");
            condensed = sys.getBoolean("OpenCard.trace.condensed");
            StringTokenizer st = new StringTokenizer(traceProperty);
            int tokenCount = st.countTokens();
            traceList = new String[tokenCount];
            traceLevels = new int[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                StringTokenizer sst = new StringTokenizer(st.nextToken(), ":");
                Tracer.traceList[i] = sst.nextToken();
                try {
                    Tracer.traceLevels[i] = sst.hasMoreTokens() ? Integer.parseInt(sst.nextToken()) : 8;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    Tracer.traceLevels[i] = 8;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Tracer(Object me, Class clazz) {
        this(me, clazz.getName());
    }

    public Tracer(Class clazz) {
        this((Object)clazz, clazz.getName());
    }

    public int getTraceLevel() {
        int traceLevel = -1;
        for (int i = 0; i < traceList.length; ++i) {
            if (traceList[i] == null || !this.myClass.startsWith(traceList[i])) continue;
            traceLevel = traceLevels[i];
        }
        return traceLevel;
    }

    public static void trace(Object me, String className, int level, String meth, String message, Throwable frisbee) {
        if (message == null && frisbee == null) {
            return;
        }
        if (className == null || traceList == null) {
            return;
        }
        for (int i = 0; i < traceList.length; ++i) {
            TracerEvent te;
            if (traceList[i] == null || !className.startsWith(traceList[i]) || level > traceLevels[i]) continue;
            TracerEvent tracerEvent = te = message != null ? new TracerEvent(level, me, meth, Thread.currentThread(), message) : new TracerEvent(level, me, meth, Thread.currentThread(), frisbee);
            if (!eventsOnly) {
                PrintWriter pw;
                StringWriter sw;
                Throwable boomerang;
                StringBuffer sb = new StringBuffer(te.getLevelName()).append(" ");
                if (te.getSource() instanceof Class) {
                    sb.append(((Class)te.getSource()).getName()).append(".");
                } else {
                    sb.append(te.getSource().getClass().getName()).append(".");
                }
                if (condensed) {
                    sb.append(te.getMethodName());
                    if (te.getMessage() != null) {
                        sb.append(":").append(te.getMessage());
                    } else {
                        boomerang = te.getThrowable();
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        boomerang.printStackTrace(pw);
                        pw.flush();
                        sb.append("--- throwable ").append(((Object)sw).toString());
                    }
                } else {
                    sb.append(te.getMethodName()).append("\n");
                    if (te.getMessage() != null) {
                        sb.append("--- message ").append(te.getMessage()).append("\n");
                    } else {
                        boomerang = te.getThrowable();
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        boomerang.printStackTrace(pw);
                        pw.flush();
                        sb.append("--- throwable ").append(((Object)sw).toString()).append("\n");
                    }
                    sb.append("--- thread ").append(te.getThread()).append("\n");
                    sb.append("--- source ").append(te.getSource()).append("\n");
                }
                System.out.println(sb.toString());
            }
            if (tracerListeners.isEmpty()) break;
            TracerListener tl = null;
            Enumeration e = tracerListeners.elements();
            while (e.hasMoreElements()) {
                tl = (TracerListener)e.nextElement();
                tl.traceEvent(te);
            }
            break;
        }
    }

    protected void trace(int level, String meth, String message) {
        Tracer.trace(this.me, this.myClass, level, meth, message, null);
    }

    protected void trace(int level, String meth, Throwable frisbee) {
        Tracer.trace(this.me, this.myClass, level, meth, null, frisbee);
    }

    public void debug(String meth, String msg) {
        this.trace(7, meth, msg);
    }

    public void debug(String meth, Throwable frisbee) {
        this.trace(7, meth, frisbee);
    }

    public void info(String meth, String msg) {
        this.trace(6, meth, msg);
    }

    public void info(String meth, Throwable frisbee) {
        this.trace(6, meth, frisbee);
    }

    public void notice(String meth, String msg) {
        this.trace(5, meth, msg);
    }

    public void notice(String meth, Throwable frisbee) {
        this.trace(5, meth, frisbee);
    }

    public void warning(String meth, String msg) {
        this.trace(4, meth, msg);
    }

    public void warning(String meth, Throwable frisbee) {
        this.trace(4, meth, frisbee);
    }

    public void error(String meth, String msg) {
        this.trace(3, meth, msg);
    }

    public void error(String meth, Throwable frisbee) {
        this.trace(3, meth, frisbee);
    }

    public void critical(String meth, String msg) {
        this.trace(2, meth, msg);
    }

    public void critical(String meth, Throwable frisbee) {
        this.trace(2, meth, frisbee);
    }

    public void alert(String meth, String msg) {
        this.trace(1, meth, msg);
    }

    public void alert(String meth, Throwable frisbee) {
        this.trace(1, meth, frisbee);
    }

    public void emergency(String meth, String msg) {
        this.trace(0, meth, msg);
    }

    public void emergency(String meth, Throwable frisbee) {
        this.trace(0, meth, frisbee);
    }

    public static void addTracerListener(TracerListener listener) {
        Tracer.trace(Tracer.class, Tracer.class.getName(), 7, "addTracerListener", "adding " + listener, null);
        tracerListeners.put(listener, listener);
        Tracer.trace(Tracer.class, Tracer.class.getName(), 7, "addTracerListener", "tracerListener " + tracerListeners, null);
    }

    public static void removeTracerListener(TracerListener listener) {
        tracerListeners.remove(listener);
    }
}

