/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

public class HexString {
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String dump(byte[] data) {
        return HexString.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int offset, int len) {
        if (data == null) {
            return "null";
        }
        char[] ascii = new char[16];
        StringBuffer out = new StringBuffer(256);
        int i = offset;
        while (i < offset + len) {
            out.append(HexString.hexify(i >>> 8 & 0xFF));
            out.append(HexString.hexify(i & 0xFF));
            out.append(":  ");
            int j = 0;
            while (j < 16) {
                if (i < data.length) {
                    int b = data[i] & 0xFF;
                    out.append(HexString.hexify(b)).append(' ');
                    ascii[j] = b >= 32 && b < 127 ? (int)b : 46;
                } else {
                    out.append("   ");
                    ascii[j] = 32;
                }
                ++j;
                ++i;
            }
            out.append(' ').append(ascii).append("\n");
        }
        return out.toString();
    }

    public static String hexify(byte[] data) {
        return HexString.hexify(data, false);
    }

    public static String hexify(byte[] data, int _offset, int _length) {
        return HexString.hexify(data, _offset, _length, false);
    }

    public static String hexify(byte[] data, boolean linewrap) {
        return HexString.hexify(data, linewrap, true);
    }

    public static String hexify(byte[] data, int _offset, int _length, boolean linewrap) {
        return HexString.hexify(data, _offset, _length, linewrap, true);
    }

    public static String hexify(byte[] data, boolean linewrap, boolean space) {
        if (data == null) {
            return "null";
        }
        return HexString.hexify(data, 0, data.length, linewrap, space);
    }

    public static String hexify(byte[] data, int _offset, int _length, boolean linewrap, boolean space) {
        if (data == null) {
            return "null";
        }
        StringBuffer out = new StringBuffer(256);
        if (_length > 0) {
            out.append(hexChars[data[_offset] >> 4 & 0xF]);
            out.append(hexChars[data[_offset] & 0xF]);
        }
        int count = _offset + _length;
        for (int i = _offset + 1; i < count; ++i) {
            if (linewrap && i % 16 == 0) {
                out.append('\n');
            } else if (i < count && space) {
                out.append(' ');
            }
            out.append(hexChars[data[i] >> 4 & 0xF]);
            out.append(hexChars[data[i] & 0xF]);
        }
        return out.toString();
    }

    public static String hexify(int val) {
        return hexChars[(val & 0xFF & 0xF0) >>> 4] + hexChars[val & 0xF];
    }

    public static String hexifyShort(byte a, byte b) {
        return HexString.hexifyShort(a & 0xFF, b & 0xFF);
    }

    public static String hexifyShort(int val) {
        return hexChars[(val & 0xFFFF & 0xF000) >>> 12] + hexChars[(val & 0xFFF & 0xF00) >>> 8] + hexChars[(val & 0xFF & 0xF0) >>> 4] + hexChars[val & 0xF];
    }

    public static String hexifyShort(int a, int b) {
        return HexString.hexifyShort(((a & 0xFF) << 8) + (b & 0xFF));
    }

    public static byte[] parseHexString(String _hexBytes) {
        int offset = 2;
        if (_hexBytes.length() > 2 && _hexBytes.charAt(2) == ' ') {
            offset = 3;
        }
        int resultLength = offset == 2 ? _hexBytes.length() / offset : (_hexBytes.length() + 1) / offset;
        byte[] result = new byte[resultLength];
        for (int i = 0; i < _hexBytes.length(); i += offset) {
            String toParse = _hexBytes.substring(i, i + 2);
            result[i / offset] = (byte)Integer.parseInt(toParse, 16);
        }
        return result;
    }

    public static byte[] parseLittleEndianHexString(String byteString) {
        byte[] result = new byte[byteString.length() / 2 + 1];
        for (int i = 0; i < byteString.length(); i += 2) {
            String toParse = byteString.substring(i, i + 2);
            result[(byteString.length() - i) / 2] = (byte)Integer.parseInt(toParse, 16);
        }
        result[0] = 0;
        return result;
    }
}

