/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;

public final class SlotChannel {
    private Tracer itracer = new Tracer((Object)this, SlotChannel.class);
    private final CardTerminal terminal;
    private final int slotID;
    private boolean slotChannelState = false;
    private Object scheduler;
    private Object lockHandle;

    public SlotChannel(CardTerminal terminal, int slotID, Object lockHandle) {
        this.terminal = terminal;
        this.slotID = slotID;
        this.slotChannelState = true;
        this.lockHandle = lockHandle;
    }

    public Object getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardTerminalException {
        return this.terminal.sendAPDU(this, capdu);
    }

    public int getSlotNumber() {
        return this.slotID;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public Object getLockHandle() {
        return this.lockHandle;
    }

    public CardID reset() throws CardTerminalException {
        return this.terminal.reset(this);
    }

    public boolean isOpen() {
        return this.slotChannelState;
    }

    public void close() throws CardTerminalException {
        this.itracer.debug("close", "closing channel");
        this.slotChannelState = false;
        this.terminal.closeSlotChannel(this);
    }

    public CardID getCardID() throws CardTerminalException {
        return this.terminal.getCardID(this.slotID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n+ state ").append(this.slotChannelState ? " open" : " closed");
        return sb.toString();
    }
}

