/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import opencard.core.util.Tracer;

public final class CardTerminalRegistry {
    private Observer observer = null;
    protected Hashtable ctListeners = new Hashtable();
    private static Tracer ctracer = new Tracer(CardTerminalRegistry.class);
    private static final CardTerminalRegistry registry = new CardTerminalRegistry();
    private Vector<CardTerminal> registeredTerminals = new Vector();

    public void setObserver(Observer o) {
        this.observer = o;
    }

    private CardTerminalRegistry() {
    }

    public static synchronized CardTerminalRegistry getRegistry() {
        return registry;
    }

    public void add(CardTerminal terminal) throws CardTerminalException {
        try {
            terminal.open();
        }
        catch (CardTerminalException ex) {
            if (ex.getMessage() != null && !ex.getMessage().toLowerCase().startsWith("port currently")) {
                throw ex;
            }
            ex.printStackTrace(System.out);
            ctracer.debug("add", ex);
        }
        this.registeredTerminals.addElement(terminal);
    }

    public void addPollable(Pollable p) {
        if (this.observer != null) {
            this.observer.updateTerminals(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardTerminal cardTerminalForName(String name) {
        CardTerminal terminal = null;
        Vector<CardTerminal> vector = this.registeredTerminals;
        synchronized (vector) {
            for (int i = 0; i < this.countCardTerminals(); ++i) {
                if (!this.registeredTerminals.elementAt(i).getName().equals(name)) continue;
                terminal = this.registeredTerminals.elementAt(i);
                break;
            }
        }
        return terminal;
    }

    public int countCardTerminals() {
        return this.registeredTerminals.size();
    }

    public Enumeration<CardTerminal> getCardTerminals() {
        return ((Vector)this.registeredTerminals.clone()).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) throws CardTerminalException {
        CardTerminal ct = null;
        Vector<CardTerminal> vector = this.registeredTerminals;
        synchronized (vector) {
            for (int i = 0; i < this.registeredTerminals.size(); ++i) {
                ct = this.registeredTerminals.elementAt(i);
                if (!ct.getName().equals(name)) continue;
                ct.close();
                this.registeredTerminals.removeElementAt(i);
                break;
            }
        }
        return false;
    }

    public boolean remove(CardTerminal terminal) throws CardTerminalException {
        ctracer.debug("remove", "closing " + terminal);
        try {
            terminal.close();
        }
        catch (Throwable ex) {
            ctracer.debug("createEventsForPresentCards", ex);
        }
        ctracer.debug("remove", "removing " + terminal);
        boolean taskAccomplished = this.registeredTerminals.removeElement(terminal);
        ctracer.debug("remove", "status " + taskAccomplished);
        return taskAccomplished;
    }

    public boolean removePollable(Pollable p) {
        if (this.observer != null) {
            return this.observer.updateTerminals(p, false);
        }
        return false;
    }

    protected void cardInserted(CardTerminal terminal, int slotID) {
        if (this.observer != null) {
            this.observer.updateCards(terminal, slotID, true);
        }
    }

    protected void cardRemoved(CardTerminal terminal, int slotID) {
        if (this.observer != null) {
            this.observer.updateCards(terminal, slotID, false);
        }
    }
}

