/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.core.util.Tracer;

public abstract class CardTerminal {
    private Tracer itracer = new Tracer((Object)this, CardTerminal.class);
    private static Tracer ctracer = new Tracer(CardTerminal.class);
    private Vector channels = new Vector();
    private int slotCount = 0;
    protected final String name;
    protected final String type;
    protected final String address;

    protected CardTerminal(String name, String type, String address) {
        ctracer.debug("<init>", "(" + name + ", " + type + ", " + address + ")");
        this.name = name;
        this.type = type;
        this.address = address;
    }

    public final Properties features() {
        Properties features = new Properties();
        this.internalFeatures(features);
        if (features == null) {
            this.itracer.debug("features ", "implementation error in terminal class -> got 'null' instead of Enumeration object");
            features = new Properties();
        }
        features.put("name", this.getName());
        features.put("type", this.getType());
        features.put("address", this.getAddress());
        features.put("slots", String.valueOf(this.slotCount));
        return features;
    }

    public String getAddress() {
        return this.address;
    }

    public abstract CardID getCardID(int var1) throws CardTerminalException;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getSlots() {
        return this.slotCount;
    }

    public abstract boolean isCardPresent(int var1) throws CardTerminalException;

    public synchronized boolean isSlotChannelAvailable(int slotID) {
        return this.getSlotChannel(slotID) == null;
    }

    public abstract void open() throws CardTerminalException;

    public abstract void close() throws CardTerminalException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SlotChannel openSlotChannel(int slotID, Object lockHandle) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        this.itracer.debug("openSlotChannel", "for slot #" + slotID);
        if (lockHandle == null) {
            this.internalOpenSlotChannel(slotID);
        } else {
            this.internalOpenSlotChannel(slotID, lockHandle);
        }
        if (slotID >= this.slotCount) {
            throw new IndexOutOfBoundsException("slot id out of bounds");
        }
        SlotChannel channel = null;
        Vector vector = this.channels;
        synchronized (vector) {
            if (!this.isSlotChannelAvailable(slotID)) {
                throw new InvalidSlotChannelException("slot channel already allocated", this);
            }
            channel = new SlotChannel(this, slotID, lockHandle);
            this.channels.addElement(channel);
        }
        this.itracer.debug("openSlotChannel", "new SlotChannel is " + channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSlotChannel(SlotChannel sc) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.removeElement(sc);
        }
        this.internalCloseSlotChannel(sc);
    }

    public final CardID reset(SlotChannel sc) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        return this.internalReset(sc.getSlotNumber(), -1);
    }

    public final ResponseAPDU sendAPDU(SlotChannel sc, CommandAPDU capdu) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        return this.internalSendAPDU(sc.getSlotNumber(), capdu, -1);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append('[');
        result.append("name=");
        result.append(this.name);
        result.append(", type=");
        result.append(this.type);
        result.append(", addr=");
        result.append(this.address);
        result.append(']');
        return result.toString();
    }

    protected void addSlots(int numberOfSlots) throws CardTerminalException {
        this.slotCount += numberOfSlots;
    }

    protected void cardRemoved(int slotID) {
        this.itracer.debug("cardRemoved", "slotID " + slotID);
        CardTerminalRegistry.getRegistry().cardRemoved(this, slotID);
    }

    protected void cardInserted(int slotID) {
        this.itracer.debug("cardInserted", "slotID " + slotID + ", )");
        CardTerminalRegistry.getRegistry().cardInserted(this, slotID);
    }

    protected Properties internalFeatures(Properties features) {
        return features;
    }

    protected void internalOpenSlotChannel(int slotID) throws CardTerminalException {
    }

    protected void internalOpenSlotChannel(int slotID, Object lockHandle) throws CardTerminalException {
        this.internalOpenSlotChannel(slotID);
    }

    protected void internalCloseSlotChannel(SlotChannel sc) throws CardTerminalException {
    }

    protected abstract CardID internalReset(int var1, int var2) throws CardTerminalException;

    protected abstract ResponseAPDU internalSendAPDU(int var1, CommandAPDU var2, int var3) throws CardTerminalException;

    protected void assertSlotChannelValid(SlotChannel sc) throws InvalidSlotChannelException {
        if (this.getSlotChannel(sc.getSlotNumber()) != sc) {
            throw new InvalidSlotChannelException("illegal SlotChannel", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SlotChannel getSlotChannel(int slotID) {
        Vector vector = this.channels;
        synchronized (vector) {
            Enumeration channs = this.channels.elements();
            while (channs.hasMoreElements()) {
                SlotChannel channel = (SlotChannel)channs.nextElement();
                if (channel.getSlotNumber() != slotID) continue;
                return channel;
            }
        }
        return null;
    }

    public ResponseAPDU sendVerifiedCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc, int ms) throws CardTerminalException {
        VerifiedAPDUInterface v = (VerifiedAPDUInterface)((Object)this);
        return v.sendVerifiedCommandAPDU(chann, capdu, vc);
    }
}

