/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardChannel;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardWaiter;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.core.util.SystemAccess;
import opencard.core.util.Tracer;

public final class SmartCard {
    private static final String VERSION = "OCF1.2;IBM Reference Implementation, Build ???, XX-XXXXXX-1999";
    private Tracer itracer = new Tracer((Object)this, SmartCard.class);
    private static Tracer ctracer = new Tracer(SmartCard.class);
    private CardServiceScheduler scheduler = null;
    private CardID cid = null;
    private CardChannel mutexCardChannel = null;
    private static boolean OCFisStarted = false;
    private Vector allocatedCS = new Vector();
    private static Vector smartCardCache = new Vector();

    public static String getVersion() {
        return VERSION;
    }

    public SmartCard(CardServiceScheduler scheduler, CardID cid) {
        ctracer.debug("<init>", "scheduler " + scheduler + ", cid " + cid);
        this.scheduler = scheduler;
        this.cid = cid;
    }

    private void assertSmartCardOpen() {
        try {
            if (!this.scheduler.isAlive()) {
                throw new OpenCardRuntimeException("SmartCard closed");
            }
        }
        catch (CardTerminalException e) {
            throw new OpenCardRuntimeException("SmartCard closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginMutex() throws InterruptedException, CardTerminalException {
        CardServiceScheduler cardServiceScheduler = this.scheduler;
        synchronized (cardServiceScheduler) {
            ctracer.debug("beginMutex", "entry " + this);
            this.assertSmartCardOpen();
            this.mutexCardChannel = this.scheduler.allocateCardChannel(this, true);
            if (this.mutexCardChannel == null) {
                throw new InterruptedException("beginMutex");
            }
            Enumeration css = this.allocatedCS.elements();
            while (css.hasMoreElements()) {
                CardService cs = (CardService)css.nextElement();
                cs.setCardChannel(this.mutexCardChannel);
            }
            ctracer.debug("beginMutex", "exit " + this);
        }
    }

    public synchronized void close() throws CardTerminalException {
        if (this.scheduler != null) {
            this.itracer.debug("close", "SmartCard closing");
            if (this.mutexCardChannel != null) {
                this.endMutex();
            }
            this.scheduler.releaseSmartCard(this);
        }
        smartCardCache.removeElement(this);
    }

    private static void configureServiceRegistry() throws CardServiceException {
        CardServiceRegistry serviceRegistry = CardServiceRegistry.getRegistry();
        StringTokenizer recordTokenizer = SmartCard.getRegistryEntry("OpenCard.services");
        if (recordTokenizer != null) {
            StringBuffer message = new StringBuffer();
            while (recordTokenizer.hasMoreElements()) {
                String factoryName = (String)recordTokenizer.nextElement();
                try {
                    Class<?> factoryClass = Class.forName(factoryName);
                    serviceRegistry.add((CardServiceFactory)factoryClass.newInstance());
                }
                catch (ClassNotFoundException cnfe) {
                    ctracer.error("<configureServiceRegistry>", cnfe.getMessage());
                    message.append("\nClass \"").append(factoryName).append("\" not found");
                }
                catch (InstantiationException ie) {
                    ctracer.error("<configureServiceRegistry>", ie.getMessage());
                    message.append("\nClass \"").append(factoryName).append("\" not instantiatable");
                }
                catch (IllegalAccessException iae) {
                    ctracer.error("<configureServiceRegistry>", iae.getMessage());
                    message.append("\nClass \"").append(factoryName).append("\" constructor not accessible");
                }
            }
            if (message.length() > 0) {
                throw new CardServiceException(message.toString());
            }
        } else {
            ctracer.debug("configureServiceRegistry", "no services entry in properties");
        }
    }

    private static void configureTerminalRegistry() throws ClassNotFoundException, CardTerminalException {
        CardTerminalRegistry d_terminalRegistry = CardTerminalRegistry.getRegistry();
        StringTokenizer recordTokenizer = SmartCard.getRegistryEntry("OpenCard.terminals");
        Hashtable factories = new Hashtable();
        if (recordTokenizer != null) {
            while (recordTokenizer.hasMoreElements()) {
                String record = (String)recordTokenizer.nextElement();
                SmartCard.handleTerminalFactoryEntries(record, factories, d_terminalRegistry);
            }
        } else {
            ctracer.debug("configureTerminalRegistry", "no terminals in properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endMutex() {
        CardServiceScheduler cardServiceScheduler = this.scheduler;
        synchronized (cardServiceScheduler) {
            ctracer.debug("endMutex", "entry " + this);
            this.assertSmartCardOpen();
            this.scheduler.releaseCardChannel(this.mutexCardChannel);
            this.mutexCardChannel = null;
            Enumeration css = this.allocatedCS.elements();
            while (css.hasMoreElements()) {
                CardService cs = (CardService)css.nextElement();
                cs.setCardChannel(null);
            }
            ctracer.debug("endMutex", "exit " + this);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (CardTerminalException ctx) {
            this.itracer.error("finalize", ctx.toString());
        }
    }

    public CardID getCardID() {
        return this.cid;
    }

    public CardService getCardService(Class clazz, boolean block) throws ClassNotFoundException, CardServiceException {
        CardService cs = null;
        this.itracer.debug("getCardService", "(" + clazz + ")");
        this.assertSmartCardOpen();
        cs = CardServiceRegistry.getRegistry().getCardServiceInstance(clazz, this.cid, this.scheduler, this, block);
        if (this.mutexCardChannel != null && this.mutexCardChannel.isOpen()) {
            cs.setCardChannel(this.mutexCardChannel);
        }
        this.allocatedCS.addElement(cs);
        return cs;
    }

    private static StringTokenizer getRegistryEntry(String tag) {
        String registryProps = SystemAccess.getSystemAccess().getProperty(tag);
        ctracer.debug("getRegistryEntry", "tag " + tag + " = " + registryProps);
        return registryProps != null ? new StringTokenizer(registryProps) : null;
    }

    public static SmartCard getSmartCard(CardTerminalEvent ctEvent, CardRequest req) throws CardTerminalException {
        return SmartCard.getSmartCard(ctEvent, req, null);
    }

    public static SmartCard getSmartCard(CardTerminalEvent ctEvent, CardRequest req, Object lockHandle) throws CardTerminalException {
        SmartCard newCard = CardServiceRegistry.getRegistry().getSmartCard(ctEvent, req, lockHandle);
        if (newCard != null) {
            smartCardCache.addElement(newCard);
        }
        return newCard;
    }

    private static void handleTerminalFactoryEntries(String record, Hashtable factories, CardTerminalRegistry terminalRegistry) throws ClassNotFoundException, CardTerminalException {
        CardTerminalFactory aFactory = null;
        String[] params = null;
        StringTokenizer elementTokenizer = new StringTokenizer(record, "|");
        int elements = elementTokenizer.countTokens();
        if (elements > 0) {
            params = new String[elements - 1];
            int counter = 0;
            String factoryName = null;
            while (elementTokenizer.hasMoreElements()) {
                if (counter == 0) {
                    factoryName = (String)elementTokenizer.nextElement();
                } else {
                    params[counter - 1] = (String)elementTokenizer.nextElement();
                }
                ++counter;
            }
            aFactory = (CardTerminalFactory)factories.get(factoryName);
            if (aFactory == null) {
                try {
                    Class<?> factoryClass = Class.forName(factoryName);
                    aFactory = (CardTerminalFactory)factoryClass.newInstance();
                    factories.put(factoryName, aFactory);
                }
                catch (InstantiationException ie) {
                    throw new CardTerminalException(ie.toString());
                }
                catch (IllegalAccessException iae) {
                    throw new CardTerminalException(iae.toString());
                }
            }
            aFactory.createCardTerminals(terminalRegistry, params);
        }
    }

    public static boolean isStarted() {
        return OCFisStarted;
    }

    public static synchronized void shutdown() throws CardTerminalException {
        if (OCFisStarted) {
            ctracer.debug("<shutdown>", "shutdown OpenCard");
            while (!smartCardCache.isEmpty()) {
                ((SmartCard)smartCardCache.firstElement()).close();
            }
            CardTerminalRegistry terminalRegistry = CardTerminalRegistry.getRegistry();
            Enumeration<CardTerminal> terminals = terminalRegistry.getCardTerminals();
            while (terminals.hasMoreElements()) {
                terminalRegistry.remove(terminals.nextElement());
            }
            CardServiceRegistry serviceRegistry = CardServiceRegistry.getRegistry();
            Enumeration serviceFactories = serviceRegistry.getCardServiceFactories();
            while (serviceFactories.hasMoreElements()) {
                serviceRegistry.remove((CardServiceFactory)serviceFactories.nextElement());
            }
            OCFisStarted = false;
            ctracer.debug("<shutdown>", "finished");
        }
    }

    public static synchronized void start() throws OpenCardPropertyLoadingException, ClassNotFoundException, CardServiceException, CardTerminalException {
        if (!OCFisStarted) {
            ctracer.debug("<start>", "startup opencard");
            String loaderClassName = SystemAccess.getSystemAccess().getProperty("OpenCard.loaderClassName", "opencard.opt.util.OpenCardPropertyFileLoader");
            if (loaderClassName != null && loaderClassName.length() > 0) {
                ctracer.debug("<start>", "use loader class: " + loaderClassName);
                try {
                    Class<?> loaderClass = Class.forName(loaderClassName);
                    OpenCardConfigurationProvider loader = (OpenCardConfigurationProvider)loaderClass.newInstance();
                    loader.loadProperties();
                    ctracer.debug("<start>", "loader loaded properties: ");
                }
                catch (InstantiationException ie) {
                    throw new CardServiceOperationFailedException(ie.toString());
                }
                catch (IllegalAccessException iae) {
                    throw new CardServiceOperationFailedException(iae.toString());
                }
            } else {
                ctracer.debug("<start>", "did not use a loader class!");
            }
            Tracer.init();
            EventGenerator.getGenerator();
            SmartCard.configureTerminalRegistry();
            SmartCard.configureServiceRegistry();
            OCFisStarted = true;
            ctracer.debug("<start>", "finished");
        } else {
            ctracer.debug("<start>", "already started");
        }
    }

    public static SmartCard waitForCard(CardRequest req) throws CardTerminalException {
        return SmartCard.waitForCard(req, null);
    }

    public static SmartCard waitForCard(CardRequest req, Object lockHandle) throws CardTerminalException {
        ctracer.debug("waitForCard", "passing request " + req + " to CardServiceRegistry");
        CardWaiter cardWaiter = new CardWaiter(req, lockHandle);
        SmartCard newCard = cardWaiter.waitForCard();
        if (newCard != null) {
            smartCardCache.addElement(newCard);
        }
        return newCard;
    }
}

