/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import opencard.core.service.CHVDialog;

public class DefaultCHVDialog
implements CHVDialog {
    @Override
    public char[] getCHV(int chvNumber) {
        ResourceBundle rb = ResourceBundle.getBundle("opencard.core.service.DefaultCHVDialogResourceBundle");
        String dialogTitle = rb.getString("chv.title");
        String dialogPrompt = rb.getString("chv.prompt.prefix") + chvNumber + rb.getString("chv.prompt.postfix");
        JFrame frame = new JFrame();
        IDDialog dialog = new IDDialog(frame, dialogTitle, dialogPrompt);
        frame.setVisible(false);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        frame.dispose();
        char[] chv = dialog.chv();
        if (chv != null && chv.length > 0) {
            return chv;
        }
        return null;
    }

    public static class IDDialog
    extends JDialog
    implements ActionListener {
        protected JButton okButton;
        protected JButton cancelButton;
        protected JLabel messageLabel;
        protected boolean finished;
        protected Object objectToNotify;
        protected JPasswordField textField;
        protected char[] chv;

        public IDDialog(JFrame parent, String title, String prompt) {
            super(parent, title, true);
            GridBagLayout gridBag = new GridBagLayout();
            this.getContentPane().setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.messageLabel = new JLabel(prompt);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            gridBag.setConstraints(this.messageLabel, c);
            this.getContentPane().add(this.messageLabel);
            c.gridx = 0;
            c.gridy = 1;
            this.textField = new JPasswordField(10);
            this.textField.addActionListener(this);
            this.textField.setEchoChar('*');
            gridBag.setConstraints(this.textField, c);
            this.getContentPane().add(this.textField);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            this.okButton = new JButton(" OK ");
            this.okButton.addActionListener(this);
            gridBag.setConstraints(this.okButton, c);
            this.getContentPane().add(this.okButton);
            c.gridx = 1;
            c.gridy = 2;
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            gridBag.setConstraints(this.cancelButton, c);
            this.getContentPane().add(this.cancelButton);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.okButton || source == this.textField) {
                this.chv = this.textField.getPassword();
            } else if (source == this.cancelButton) {
                this.chv = null;
            }
            this.setVisible(false);
        }

        public char[] chv() {
            return this.chv;
        }
    }
}

