/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardIDFilter;
import opencard.core.service.CardRequest;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.PrimaryCardServiceFactory;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardServiceRegistry {
    private Tracer itracer = new Tracer((Object)this, CardServiceRegistry.class);
    private static Tracer ctracer = new Tracer(CardServiceRegistry.class);
    private static final CardServiceRegistry registry = new CardServiceRegistry();
    private Vector factories = new Vector();
    private Hashtable slot2channel = new Hashtable();

    private CardServiceRegistry() {
        ctracer.debug("<init>", "instantiating");
    }

    public void add(CardServiceFactory factory) {
        this.itracer.debug("add", " " + factory);
        this.factories.addElement(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardServiceScheduler allocateCardServiceScheduler(SlotChannel channel) throws CardTerminalException {
        CardServiceScheduler scheduler = null;
        SlotChannel slotChannel = channel;
        synchronized (slotChannel) {
            scheduler = (CardServiceScheduler)channel.getScheduler();
            if (scheduler == null) {
                this.itracer.debug("allocateCardServiceScheduler", "instantiating CardServiceScheduler");
                scheduler = new CardServiceScheduler(channel);
                channel.setScheduler(scheduler);
                Enumeration factories = this.getCardServiceFactories();
                while (factories.hasMoreElements()) {
                    CardServiceFactory factory = (CardServiceFactory)factories.nextElement();
                    if (!(factory instanceof PrimaryCardServiceFactory)) continue;
                    this.itracer.debug("allocateCardServiceScheduler", "setting up card via PrimaryCardServiceFactory" + factory);
                    ((PrimaryCardServiceFactory)((Object)factory)).setupSmartCard(channel);
                    break;
                }
            }
        }
        return scheduler;
    }

    protected Class getCardServiceClassFor(Class clazz, CardID cid, CardServiceScheduler scheduler) {
        this.itracer.debug("getCardServiceClass", "for " + clazz + " and " + cid);
        Enumeration factoryEnum = this.getCardServiceFactories();
        while (factoryEnum.hasMoreElements()) {
            CardServiceFactory factory = (CardServiceFactory)factoryEnum.nextElement();
            this.itracer.debug("getCardServiceClass", "checking " + factory);
            CardType type = scheduler.getCardTypeFor(factory);
            if (type == null) {
                try {
                    type = factory.getCardType(cid, scheduler);
                    scheduler.setCardTypeFor(factory, type);
                }
                catch (CardTerminalException t) {
                    this.itracer.debug("getCardServiceClass", t);
                    t.printStackTrace();
                    continue;
                }
            }
            if (CardType.UNSUPPORTED == type) continue;
            Class cardServiceClass = factory.getClassFor(clazz, type);
            this.itracer.debug("getCardServiceClass", "factory " + factory + " produced " + cardServiceClass);
            if (cardServiceClass == null) continue;
            return cardServiceClass;
        }
        this.itracer.info("getCardServiceClass", "no CardService for " + clazz);
        return null;
    }

    public final Enumeration getCardServiceFactories() {
        return ((Vector)this.factories.clone()).elements();
    }

    protected CardService getCardServiceInstance(Class clazz, CardID cid, CardServiceScheduler scheduler, SmartCard card, boolean block) throws ClassNotFoundException {
        this.itracer.debug("getCardServiceInstance", "for " + clazz + " from " + card);
        Enumeration factories = this.getCardServiceFactories();
        while (factories.hasMoreElements()) {
            CardServiceFactory factory = (CardServiceFactory)factories.nextElement();
            this.itracer.debug("getCardServiceInstance", "checking " + factory);
            CardType type = scheduler.getCardTypeFor(factory);
            if (type == null) {
                try {
                    type = factory.getCardType(cid, scheduler);
                    scheduler.setCardTypeFor(factory, type);
                }
                catch (CardTerminalException t) {
                    this.itracer.debug("getCardServiceInstance", t);
                    t.printStackTrace();
                    continue;
                }
            }
            if (CardType.UNSUPPORTED == type) continue;
            try {
                CardService service = factory.getCardServiceInstance(clazz, type, scheduler, card, block);
                this.itracer.debug("getCardServiceInstance", "factory " + factory + " produced " + service);
                if (service == null) continue;
                return service;
            }
            catch (CardServiceException csx) {
                this.itracer.info("getCardServiceInstance", "factory " + factory + " failed: " + csx);
            }
        }
        this.itracer.info("getCardServiceInstance", "no CardService for " + clazz + " found");
        throw new ClassNotFoundException("CardService implementing " + clazz.toString());
    }

    public static CardServiceRegistry getRegistry() {
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SmartCard getSmartCard(CardTerminalEvent ctEvent, CardRequest req, Object lockHandle) throws CardTerminalException {
        this.itracer.debug("getSmartCard", "CTEvent " + ctEvent);
        boolean newScheduler = false;
        CardTerminal terminal = (CardTerminal)ctEvent.getSource();
        SlotChannel channel = null;
        int slotID = ctEvent.getSlotID();
        CardID cid = terminal.getCardID(slotID);
        Integer hashCode = new Integer(terminal.hashCode() + slotID);
        Hashtable hashtable = this.slot2channel;
        synchronized (hashtable) {
            channel = (SlotChannel)this.slot2channel.get(hashCode);
            if (channel != null && channel.getLockHandle() == lockHandle) {
                this.itracer.debug("getSmartCard", "secondary waitForCard(); don't need to open SlotChannel again");
            } else {
                channel = terminal.openSlotChannel(slotID, lockHandle);
                this.slot2channel.put(hashCode, channel);
            }
        }
        CardServiceScheduler scheduler = (CardServiceScheduler)channel.getScheduler();
        if (scheduler == null) {
            scheduler = this.allocateCardServiceScheduler(channel);
            newScheduler = true;
        }
        if (req != null && !this.isCardRequestSatisfied(req, cid, terminal, scheduler)) {
            this.itracer.info("getSmartCard", "CardRequest " + req + " cannot be satisfied with " + cid);
            if (newScheduler) {
                scheduler.closeDown();
            }
            return null;
        }
        this.itracer.debug("getSmartCard", "using CardServiceScheduler " + scheduler);
        return scheduler.createSmartCard(cid);
    }

    private boolean isCardRequestSatisfied(CardRequest req, CardID cid, CardTerminal terminal, CardServiceScheduler scheduler) {
        CardIDFilter filter = req.getFilter();
        if (filter != null && !filter.isCandidate(cid)) {
            this.itracer.info("isCardRequestSatisfied", "filtered out by " + filter);
            return false;
        }
        if (req.getCardTerminal() != null && req.getCardTerminal() != terminal) {
            this.itracer.info("isCardRequestSatisfied", "requested terminal " + req.getCardTerminal() + " does not match receiving terminal " + terminal);
            return false;
        }
        if (req.getCardServiceClass() != null && this.getCardServiceClassFor(req.getCardServiceClass(), cid, scheduler) == null) {
            this.itracer.info("isCardRequestSatisfied", "requested CardService class " + req.getCardServiceClass() + " not supported for  " + cid);
            return false;
        }
        return true;
    }

    protected void releaseScheduler(CardServiceScheduler scheduler) {
        int hashCode = scheduler.getSlotChannel().getCardTerminal().hashCode() + scheduler.getSlotChannel().getSlotNumber();
        this.slot2channel.remove(new Integer(hashCode));
    }

    public void remove(CardServiceFactory factory) {
        this.itracer.debug("remove", " " + factory);
        this.factories.removeElement(factory);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        Enumeration factories = this.getCardServiceFactories();
        while (factories.hasMoreElements()) {
            CardServiceFactory factory = (CardServiceFactory)factories.nextElement();
            sb.append("++ registered factory ").append(factory).append("\n");
        }
        return sb.toString();
    }
}

