/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.Tracer;

public abstract class CardServiceFactory {
    private Tracer itracer = new Tracer((Object)this, CardServiceFactory.class);
    private Tracer ctracer = new Tracer(CardServiceFactory.class);

    public CardServiceFactory() {
        this.ctracer.debug("<init>", "instantiating");
    }

    protected CardService getCardServiceInstance(Class clazz, CardType type, CardServiceScheduler scheduler, SmartCard card, boolean block) throws CardServiceException {
        Class serviceClass = this.getClassFor(clazz, type);
        if (serviceClass != null) {
            return this.newCardServiceInstance(serviceClass, type, scheduler, card, block);
        }
        return null;
    }

    protected Class getClassFor(Class clazz, CardType type) {
        Enumeration services = this.getClasses(type);
        while (services.hasMoreElements()) {
            Class serviceClass = (Class)services.nextElement();
            this.itracer.debug("getClassFor", "checking " + serviceClass);
            if (!clazz.isAssignableFrom(serviceClass)) continue;
            return serviceClass;
        }
        return null;
    }

    protected CardService newCardServiceInstance(Class clazz, CardType type, CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        this.itracer.debug("newCardServiceInstance", "instantiating " + clazz);
        CardService instance = null;
        try {
            instance = (CardService)clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (instance != null) {
            instance.initialize(scheduler, card, blocking);
        }
        return instance;
    }

    protected abstract CardType getCardType(CardID var1, CardServiceScheduler var2) throws CardTerminalException;

    protected abstract Enumeration getClasses(CardType var1);
}

