/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CardIDFilter;
import opencard.core.terminal.CardTerminal;

public class CardRequest {
    public static final int ANYCARD = 1;
    public static final int NEWCARD = 2;
    private CardIDFilter cardIDFilter = null;
    private int timeout = 0;
    private boolean timeoutSet = false;
    private Class cardServiceClass = null;
    private CardTerminal terminal = null;
    private int how = 1;

    public CardRequest(int waitBehavior, CardTerminal terminal, Class cardServiceClass) {
        this.how = waitBehavior;
        this.terminal = terminal;
        this.cardServiceClass = cardServiceClass;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            this.timeout = 0;
            this.timeoutSet = false;
        } else {
            this.timeout = timeout;
            this.timeoutSet = true;
        }
    }

    public void setFilter(CardIDFilter filter) {
        this.cardIDFilter = filter;
    }

    public CardIDFilter getFilter() {
        return this.cardIDFilter;
    }

    public Class getCardServiceClass() {
        return this.cardServiceClass;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWaitBehavior() {
        return this.how;
    }

    public boolean isTimeoutSet() {
        return this.timeoutSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        String s = " unknown wait behavior";
        switch (this.how) {
            case 1: {
                s = " ANYCARD";
                break;
            }
            case 2: {
                s = " NEWCARD";
            }
        }
        sb.append(s);
        if (this.cardIDFilter != null) {
            sb.append("\nfilter   = ").append(this.cardIDFilter);
        }
        if (this.cardServiceClass != null) {
            sb.append("\nservice  = ").append(this.cardServiceClass);
        }
        if (this.terminal != null) {
            sb.append("\nterminal = ").append(this.terminal);
        }
        if (this.timeoutSet) {
            sb.append("\ntimeout  = ").append(this.timeout);
        }
        return sb.toString();
    }
}

