/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.DefaultCHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;

public final class CardHolderVerificationGUI {
    private int chvNumber = -1;
    private CHVDialog chvDialog = new DefaultCHVDialog();

    protected CardHolderVerificationGUI() {
    }

    protected void clearDisplay() {
        this.chvNumber = -1;
    }

    protected void display(int num) {
        this.chvNumber = num;
    }

    protected char[] keyboardInput(CardTerminalIOControl ioControl, CHVDialog customCHVDialog) {
        if (customCHVDialog != null) {
            return customCHVDialog.getCHV(this.chvNumber);
        }
        return this.chvDialog.getCHV(this.chvNumber);
    }

    protected char[] promptUser(int chvNumber, CardTerminalIOControl ioControl, CHVDialog customCHVDialog) {
        this.clearDisplay();
        this.display(chvNumber);
        return this.keyboardInput(ioControl, customCHVDialog);
    }

    public ResponseAPDU sendVerifiedAPDU(SlotChannel slotchan, CommandAPDU command, CHVControl control, CHVDialog dialog) throws CardTerminalException, CardServiceInvalidCredentialException {
        if (!control.passwordEncoding().equals("T.50 Encoding")) {
            throw new CardTerminalException("verification type not supported: " + control.toString());
        }
        char[] password = this.promptUser(control.chvNumber(), control.ioControl(), dialog);
        if (password == null) {
            throw new CardServiceInvalidCredentialException("CHV cancelled");
        }
        int offset = control.passwordOffset();
        int length = Math.min(control.ioControl().maxInputChars(), password.length);
        for (int i = 0; i < length; ++i) {
            command.setByte(5 + offset + i, (byte)password[i]);
        }
        if (!slotchan.isOpen()) {
            throw new CardTerminalException("SlotChannel closed");
        }
        ResponseAPDU response = slotchan.sendAPDU(command);
        return response;
    }
}

