/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardHolderVerificationGUI;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.core.util.Tracer;

public class CardChannel {
    private Tracer itracer = new Tracer((Object)this, CardChannel.class);
    private static Tracer ctracer = new Tracer(CardChannel.class);
    private SlotChannel slot_channel = null;
    private boolean is_open = false;
    private boolean is_jammed = false;
    private Object channel_state = null;

    protected CardChannel(SlotChannel slotchannel) {
        this.slot_channel = slotchannel;
        this.is_open = false;
        this.is_jammed = false;
        ctracer.debug("<init>", "(" + slotchannel + ")");
    }

    public final boolean isOpen() {
        return this.is_open;
    }

    private void assertCardChannelOpen() throws InvalidCardChannelException {
        if (!this.is_open) {
            throw new InvalidCardChannelException("CardChannel not open");
        }
    }

    public CardTerminal getCardTerminal() {
        this.assertCardChannelOpen();
        return this.slot_channel.getCardTerminal();
    }

    public final void setState(Object state) {
        this.channel_state = state;
    }

    public final Object getState() {
        return this.channel_state;
    }

    public ResponseAPDU sendCommandAPDU(CommandAPDU cmdAPDU) throws InvalidCardChannelException, CardTerminalException {
        this.assertCardChannelOpen();
        this.itracer.debug("sendCommandAPDU", cmdAPDU.toString());
        ResponseAPDU rapdu = this.slot_channel.sendAPDU(cmdAPDU);
        return rapdu;
    }

    public final ResponseAPDU sendVerifiedAPDU(CommandAPDU command, CHVControl control, CHVDialog dialog) throws InvalidCardChannelException, CardTerminalException, CardServiceInvalidCredentialException {
        this.assertCardChannelOpen();
        this.itracer.debug("sendVerifiedAPDU", "(" + command + ")");
        ResponseAPDU response = null;
        if (this.getCardTerminal() instanceof VerifiedAPDUInterface) {
            VerifiedAPDUInterface terminal = (VerifiedAPDUInterface)((Object)this.getCardTerminal());
            response = terminal.sendVerifiedCommandAPDU(this.slot_channel, command, control);
        } else {
            CardHolderVerificationGUI gui = new CardHolderVerificationGUI();
            response = gui.sendVerifiedAPDU(this.slot_channel, command, control, dialog);
        }
        this.itracer.debug("sendVerifiedAPDU", "response: " + response);
        return response;
    }

    public void open() throws InvalidCardChannelException {
        this.itracer.debug("open", "opening CardChannel");
        if (this.is_jammed) {
            throw new InvalidCardChannelException("cannot be opened anymore");
        }
        if (this.is_open) {
            throw new InvalidCardChannelException("already open");
        }
        this.is_open = true;
    }

    public void close() {
        this.is_open = false;
        this.itracer.debug("close", "CardChannel closed");
    }

    protected void closeFinal() {
        this.itracer.debug("closeFinal", "closing for good");
        this.close();
        this.is_jammed = true;
    }

    protected void finalize() throws Throwable {
        this.closeFinal();
        super.finalize();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", ").append(this.is_open ? "is" : "not").append(" open");
        sb.append(", ").append(this.is_jammed ? "is" : "not").append(" jammed");
        return sb.toString();
    }
}

