/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.event;

import opencard.core.OpenCardConstants;
import opencard.core.event.OpenCardEvent;
import opencard.core.util.TraceLevels;

public class TracerEvent
extends OpenCardEvent
implements OpenCardConstants,
TraceLevels {
    public static final int TRACE_EVENT = 1;
    private int level = -1;
    private String levelName = null;
    private transient Thread thread = null;
    private Throwable frisbee = null;
    private String meth = null;
    private String msg = null;

    private TracerEvent(int level, Object source, String meth, Thread thread) {
        super(source, 1);
        this.level = level;
        this.levelName = levelAsString[level];
        this.meth = meth;
        this.thread = thread;
    }

    public TracerEvent(int level, Object source, String meth, Thread thread, Throwable frisbee) {
        this(level, source, meth, thread);
        this.frisbee = frisbee;
    }

    public TracerEvent(int level, Object source, String meth, Thread thread, String msg) {
        this(level, source, meth, thread);
        this.msg = msg;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Throwable getThrowable() {
        return this.frisbee;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getMethodName() {
        return this.meth;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelName() {
        return this.levelName;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n---level     ").append(this.levelName);
        sb.append("\n---method    ").append(this.meth);
        sb.append("\n---thread    ").append(this.thread);
        if (this.frisbee != null) {
            sb.append("\n---throwable ").append(this.frisbee);
        }
        if (this.msg != null) {
            sb.append("\n---msg       ").append(this.msg);
        }
        return sb.toString();
    }
}

