/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.event;

import java.util.Enumeration;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Observer;
import opencard.core.terminal.Pollable;
import opencard.core.util.Tracer;

public final class EventGenerator
implements Observer,
Runnable {
    private static Tracer ctracer = new Tracer(EventGenerator.class);
    private Vector listeners = new Vector();
    private static EventGenerator theGenerator = null;
    private Thread t = null;
    private static int pollInterval = 500;
    private Vector pollables = new Vector();
    private boolean cancel = false;

    public static EventGenerator getGenerator() {
        if (theGenerator == null) {
            theGenerator = new EventGenerator();
            CardTerminalRegistry.getRegistry().setObserver(theGenerator);
        }
        return theGenerator;
    }

    public void cancelEventThread() {
        this.cancel = true;
    }

    public void addCTListener(CTListener listener) {
        this.listeners.addElement(listener);
    }

    public void createEventsForPresentCards(CTListener ctListener) throws CardTerminalException {
        Enumeration<CardTerminal> e = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (e.hasMoreElements()) {
            CardTerminal ct = e.nextElement();
            if (ct == null) continue;
            int slots = ct.getSlots();
            for (int i = 0; i < slots; ++i) {
                boolean b = false;
                try {
                    b = ct.isCardPresent(i);
                }
                catch (Throwable ex) {
                    ctracer.debug("createEventsForPresentCards", ex);
                }
                if (!b) continue;
                ctListener.cardInserted(new CardTerminalEvent(ct, 1, i));
            }
        }
    }

    public void removeAllCTListeners() {
        this.listeners.clear();
    }

    public void removeCTListener(CTListener ctListener) {
        this.listeners.removeElement(ctListener);
    }

    public void setPollInterval(int duration) {
        pollInterval = duration;
    }

    public int getPollInterval() {
        return pollInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.cancel = false;
        while (!this.cancel) {
            try {
                Thread.sleep(pollInterval);
                Vector vector = this.pollables;
                synchronized (vector) {
                    Enumeration e = this.pollables.elements();
                    while (e.hasMoreElements()) {
                        Pollable p = (Pollable)e.nextElement();
                        try {
                            p.poll();
                        }
                        catch (RuntimeException rte) {
                            ctracer.debug("run", rte);
                        }
                        catch (CardTerminalException cte) {
                            ctracer.debug("run", cte);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void updateCards(CardTerminal terminal, int slotID, boolean cardInserted) {
        ctracer.debug("updateCards", "card " + (cardInserted ? "inserted" : "removed") + " slotID = " + slotID);
        if (!this.listeners.isEmpty()) {
            CTListener ctl = null;
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ctl = (CTListener)e.nextElement();
                try {
                    if (cardInserted) {
                        ctl.cardInserted(new CardTerminalEvent(terminal, 1, slotID));
                        continue;
                    }
                    ctl.cardRemoved(new CardTerminalEvent(terminal, 2, slotID));
                }
                catch (RuntimeException rte) {
                    ctracer.critical("updateCards", rte);
                }
                catch (CardTerminalException cte) {
                    ctracer.critical("updateCards", cte);
                }
            }
            ctracer.debug("updateCards", "notified CTListeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTerminals(Pollable p, boolean terminalAdded) {
        Vector vector = this.pollables;
        synchronized (vector) {
            if (terminalAdded) {
                ctracer.debug("updateTerminals", "new pollable Terminal = " + p);
                this.pollables.addElement(p);
                try {
                    p.poll();
                }
                catch (RuntimeException rte) {
                    ctracer.debug("run", rte);
                }
                catch (CardTerminalException cte) {
                    ctracer.debug("run", cte);
                }
                if (this.t == null) {
                    this.t = new Thread(this);
                    this.t.setDaemon(true);
                    this.t.start();
                }
                return true;
            }
            ctracer.debug("updateTerminals", "remove pollable Terminal = " + p);
            return this.pollables.removeElement(p);
        }
    }

    private EventGenerator() {
    }
}

