/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.version;

import de.governikus.CompInfo.ComponentInfo;
import java.text.DecimalFormat;

public interface Versioned {
    public static final int VERSION_FRACTION_FACTOR = 1000;
    public static final int MINOR_VERSION_FRACTION_FACTOR = 1000;
    public static final int MAJOR_VERSION_FRACTION_FACTOR = 1000000;
    public static final int RELEASE_VERSION_FRACTION_FACTOR = 1000000000;

    public double getVersion();

    public String getVersionAsString();

    public int getRelease();

    public int getMajor();

    public int getMinor();

    public int getBuild();

    public static final class Util {
        private Util() {
        }

        public static String getVersionString(double version) {
            DecimalFormat df = new DecimalFormat("##0");
            return df.format(Util.getRelease(version)) + "." + df.format(Util.getMajor(version)) + "." + df.format(Util.getMinor(version));
        }

        public static int getRelease(double version) {
            return (int)(version / 1.0E9);
        }

        public static int getMajor(double version) {
            return (int)((version - (double)(Util.getRelease(version) * 1000000000)) / 1000000.0);
        }

        public static int getMinor(double version) {
            return (int)((version - (double)(Util.getRelease(version) * 1000000000) - (double)(Util.getMajor(version) * 1000000)) / 1000.0);
        }

        public static int getBuild(double version) {
            return (int)(version - (double)(Util.getRelease(version) * 1000000000) - (double)(Util.getMajor(version) * 1000000) - (double)(Util.getMinor(version) * 1000));
        }

        public static double getComponentInfoVersion(String resource) {
            String componentVersion = new ComponentInfo(resource).getComponentVersion();
            if (componentVersion.contains("-")) {
                componentVersion = componentVersion.substring(0, componentVersion.indexOf("-"));
            }
            String[] versionParts = componentVersion.split("\\.");
            double version = 0.0;
            if (versionParts.length >= 1) {
                version += (double)(Integer.parseInt(versionParts[0]) * 1000000000);
            }
            if (versionParts.length >= 2) {
                version += (double)(Integer.parseInt(versionParts[1]) * 1000000);
            }
            if (versionParts.length >= 3) {
                version += (double)(Integer.parseInt(versionParts[2]) * 1000);
            }
            if (versionParts.length >= 4) {
                version += (double)Integer.parseInt(versionParts[3]);
            }
            return version;
        }
    }
}

