/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.util;

import de.bos_bremen.gov2.jca_provider.ocf.model.CardEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.opencard.util.CardCountListener;
import opencard.core.event.EventGenerator;
import org.apache.log4j.Logger;

public class MCardWaiter {
    private static final Logger LOG = Logger.getLogger(MCardWaiter.class);
    public static final int DEFAULT_TIME_DETECTION = 1500;
    public static final int DEFAULT_TIME_CARD = 10000;
    private Object sync = new Object();
    private CardCountListener cardCounterListener = null;
    private CardListener cardListener = null;
    private WaiterState state = WaiterState.WAIT;
    private long startTime = System.currentTimeMillis();
    private int waitTimeDetection = 1500;
    private int waitTimeCard = 10000;
    private int cardEventCounter = 0;

    public MCardWaiter() {
        this(1500, 10000);
    }

    public MCardWaiter(int waitTimeDetection, int waitTimeCard) {
        this.waitTimeDetection = waitTimeDetection;
        this.waitTimeCard = waitTimeCard;
        EventGenerator generator = EventGenerator.getGenerator();
        this.cardCounterListener = new CardCountListener("MCardWaiter");
        this.cardListener = new CardListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processEvent(CardEvent cardEvent) {
                if (cardEvent.getType() == 0) {
                    ++MCardWaiter.this.cardEventCounter;
                    if (MCardWaiter.this.cardEventCounter == MCardWaiter.this.cardCounterListener.getCount()) {
                        Object object = MCardWaiter.this.sync;
                        synchronized (object) {
                            LOG.debug((Object)"CardListener notifies...");
                            MCardWaiter.this.state = WaiterState.NO_WAIT;
                            MCardWaiter.this.sync.notify();
                        }
                    }
                }
            }
        };
        generator.addCTListener(this.cardCounterListener);
        CardObjectRegistryImpl.getInstance().addCardListener(this.cardListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForPresentCards() throws IllegalStateException {
        if (this.state == WaiterState.DESTROYED) {
            throw new IllegalStateException("waiter destroyed");
        }
        long timeWait = System.currentTimeMillis() - this.startTime;
        if (timeWait < (long)this.waitTimeDetection) {
            LOG.debug((Object)"***************************** too early");
            CardCountListener cardCountListener = this.cardCounterListener;
            synchronized (cardCountListener) {
                try {
                    this.cardCounterListener.wait((long)this.waitTimeDetection - timeWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.debug((Object)"***************************** too early DONE");
            }
        }
        if (this.cardCounterListener.getCount() > 0) {
            if (this.state == WaiterState.WAIT) {
                long s = System.currentTimeMillis();
                Object object = this.sync;
                synchronized (object) {
                    LOG.debug((Object)"card, wait (card not processed)");
                    try {
                        this.sync.wait(this.waitTimeCard);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"waiting interrupted");
                    }
                }
                long e = System.currentTimeMillis();
                LOG.debug((Object)("card waiting time: " + (e - s) + " ms"));
                LOG.debug((Object)"card, wait (card hopefully processed)");
            } else {
                LOG.debug((Object)"card, no wait (card processed)");
            }
        } else {
            LOG.debug((Object)"no card, no wait");
        }
    }

    public synchronized void reset() throws IllegalStateException {
        if (this.state == WaiterState.DESTROYED) {
            throw new IllegalStateException("waiter destroyed");
        }
        this.state = WaiterState.WAIT;
        this.cardCounterListener.reset();
        this.startTime = System.currentTimeMillis();
        this.cardEventCounter = 0;
        CardObjectRegistryImpl.getInstance().addCardListener(this.cardListener);
    }

    public synchronized void destroy() {
        EventGenerator generator = EventGenerator.getGenerator();
        generator.removeCTListener(this.cardCounterListener);
        CardObjectRegistryImpl.getInstance().removeCardListener(this.cardListener);
        this.sync = null;
        this.cardCounterListener = null;
    }

    static enum WaiterState {
        WAIT,
        NO_WAIT,
        DESTROYED;

    }
}

