/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal.pcsc;

import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.jni.pcsc.PCSCReaderState;
import de.bos_bremen.userconf.xml.TerminalType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;
import opencard.opt.terminal.PowerManagementInterface;
import opencard.opt.terminal.TerminalCommand;

public abstract class PCSCCardTerminal
extends CardTerminal
implements TerminalCommand,
Pollable,
PowerManagementInterface {
    public static final String SYSTEM_PROPERTY_KEY_USES_STANDARD_ISO_TPDU = "Uses_Standard_ISO_TPDU";
    protected Tracer itracer = null;
    protected Pcsc20Features pcsc20features = null;
    protected long cardHandle = 0L;
    protected boolean transactionLocked = false;
    protected CardID cid = null;
    protected boolean closed = true;
    protected boolean cachedCardStatus = false;
    protected boolean tpdu_Uses_ISO = true;
    protected int shareMode = 2;
    protected boolean cardInserted = false;
    protected TerminalType terminalType = null;

    public final TerminalType getTerminalType() {
        return this.terminalType;
    }

    protected PCSCCardTerminal(String name, String type, String address, TerminalType terminalType) {
        super(name, type, address);
        this.terminalType = terminalType;
    }

    public abstract PCSCReaderState getCardStatus(long var1) throws CardTerminalException, IllegalArgumentException;

    public abstract PCSCReaderState getStatus(long var1, int var3) throws CardTerminalException, IllegalArgumentException;

    public abstract long establishContext() throws Exception;

    public abstract void releaseContext(long var1) throws Exception;

    public abstract long connect(long var1, int var3, boolean var4) throws Exception;

    public abstract long connect(long var1, int var3, boolean var4, Protocol var5) throws Exception;

    public abstract void disconnect(long var1, int var3) throws Exception;

    public abstract boolean beginTransaction(long var1) throws IllegalStateException;

    public abstract boolean beginTransaction(long var1, long var3) throws Exception;

    public abstract boolean endTransaction();

    public abstract boolean endTransaction(long var1) throws Exception;

    public abstract ResponseAPDU transmit(long var1, int var3, CommandAPDU var4, int var5) throws Exception;

    public abstract byte[] sendTerminalCommand(int var1, byte[] var2) throws CardTerminalException;

    public abstract void resetSlot(int var1) throws CardTerminalException;

    abstract byte[] powerUpCard(int var1, int var2, int var3, Boolean var4) throws CardTerminalException;

    abstract byte[] powerUpCard(int var1, int var2, int var3, Boolean var4, Protocol var5) throws CardTerminalException;

    public abstract void cardDisconnect(int var1) throws CardTerminalException;

    public Pcsc20Features getPcsc20Features() {
        return this.pcsc20features;
    }

    public boolean isConnected() {
        return this.cardHandle == 0L;
    }

    public synchronized boolean isTransactionLocked() {
        return this.transactionLocked;
    }

    @Override
    public void powerUpCard(int slotID, int timeout) throws CardTerminalException {
        try {
            this.powerUpCard(slotID, timeout, 0, null, null);
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CardTerminalException(e.getMessage());
        }
    }

    @Override
    public void powerDownCard(int slotID, int timeout) throws CardTerminalException {
        this.cardDisconnect(2);
    }

    @Override
    public byte[] sendTerminalCommand(byte[] cmd) throws CardTerminalException {
        return this.sendTerminalCommand(0, cmd);
    }

    @Override
    public CardID getCardID(int slot) throws CardTerminalException {
        if (slot != 0) {
            throw new CardTerminalException("Invalid slot number: " + Integer.toString(slot));
        }
        if (this.cachedCardStatus && this.cid != null) {
            return this.cid;
        }
        return null;
    }

    @Override
    public synchronized boolean isCardPresent(int slotID) throws CardTerminalException {
        if (slotID != 0) {
            throw new CardTerminalException("Invalid slot number: " + Integer.toString(slotID));
        }
        return this.cachedCardStatus;
    }

    @Override
    protected synchronized void internalOpenSlotChannel(int slotID) throws CardTerminalException {
        this.itracer.debug("internalOpenSlotChannel", "CONNECTING TO CARD: " + slotID);
        this.powerUpCard(slotID, -1);
        try {
            this.beginTransaction(45000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    protected void internalCloseSlotChannel(SlotChannel slotchannel) throws CardTerminalException {
        super.internalCloseSlotChannel(slotchannel);
        this.powerDownCard(slotchannel.getSlotNumber(), -1);
    }

    protected final void checkCardHandle(long compareHandle) {
        if (this.cardHandle != compareHandle) {
            throw new IllegalArgumentException("card handle does match internal handle");
        }
        if (this.isConnected()) {
            throw new IllegalArgumentException("card not connected");
        }
    }

    protected static int convertByte(int value) {
        int result = value & 0x7F;
        if ((value & 0x80) == 128) {
            result += 128;
        }
        return result;
    }

    protected final void checkNonNullResponse(byte[] bytes) throws CardTerminalException {
        if (bytes == null) {
            throw new CardTerminalException("No response from reader. ", this);
        }
    }

    public int getSharedMode() {
        return this.shareMode;
    }
}

