/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal.pcsc;

import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.java.pcsc.JPCSC;
import de.bos_bremen.java.pcsc.impl.JPCSCFactoryImpl;
import de.bos_bremen.jni.pcsc.PCSCException;
import de.bos_bremen.opencard.terminal.SubCardTerminalFactory;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSTerminalFactory;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import de.bos_bremen.userconf.UserConfigurationManager;
import de.bos_bremen.userconf.impl.DefaultUserConfigurationManager;
import de.bos_bremen.userconf.xml.DriverType;
import de.bos_bremen.userconf.xml.DriversType;
import de.bos_bremen.userconf.xml.SCConfiguration;
import de.bos_bremen.userconf.xml.SCDriverTypes;
import de.bos_bremen.userconf.xml.TerminalType;
import de.bos_bremen.userconf.xml.TerminalsType;
import de.bos_bremen.userconf.xml.UserConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JPCSCCardTerminalFactory
implements SubCardTerminalFactory {
    private static final Log LOG = LogFactory.getLog(JPCSCCardTerminalFactory.class);
    public static final String CATCH_ALL_NAME = "*";
    private static JPCSC jpcsc = null;
    private static UserConfigurationManager ucm = null;
    private static Map<TerminalType, Integer> internalUsedTerminalTypeMap = new HashMap<TerminalType, Integer>();
    private static List<TerminalType> externalUsedTerminalTypeList = new ArrayList<TerminalType>();

    public static void setJPCSC(JPCSC instance) {
        jpcsc = instance;
    }

    public JPCSCCardTerminalFactory() {
        JPCSCCardTerminalFactory.setJPCSC((JPCSC)JPCSCFactoryImpl.getFactory().getImplementation(SystemEnum.getCurrentSystem().ordinal()));
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, String[] terminalInfo) throws CardTerminalException, IllegalArgumentException {
        LOG.debug((Object)"JPCSCCardTerminalFactory.createCardTerminals()...");
        List<String> pcscReaderList = null;
        pcscReaderList = terminalInfo == null || terminalInfo.length == 0 ? JPCSCCardTerminalFactory.listReaders() : Arrays.asList(terminalInfo);
        if (pcscReaderList == null || pcscReaderList.isEmpty()) {
            return;
        }
        if (ucm != null) {
            UserConfiguration uc = ucm.getConfiguration();
            SCConfiguration scConfiguration = uc.getSmartcard();
            DriversType driver = scConfiguration.getDrivers();
            List<DriverType> listDrivers = driver.getDriver();
            if (listDrivers == null || listDrivers.isEmpty()) {
                return;
            }
            boolean pcscEnabled = false;
            for (DriverType dt : driver.getDriver()) {
                if (dt.getName() != SCDriverTypes.PCSC || !dt.isEnabled()) continue;
                pcscEnabled = true;
                break;
            }
            if (!pcscEnabled) {
                return;
            }
            TerminalsType tt = scConfiguration.getTerminals();
            if (tt != null && tt.getTerminal() != null && !tt.getTerminal().isEmpty()) {
                boolean catchAll = false;
                ArrayList<TerminalType> copyTerminalTypeList = new ArrayList<TerminalType>();
                copyTerminalTypeList.addAll(tt.getTerminal());
                for (TerminalType t : tt.getTerminal()) {
                    if (!CATCH_ALL_NAME.equals(t.getName())) continue;
                    if (t.isEnabled() && t.getTypes() != null && t.getTypes().getPcsc() == null) {
                        LOG.debug((Object)"catch all terminal found: enabled, PC/SC not configured, so default enabled");
                        catchAll = true;
                    } else if (t.isEnabled() && t.getTypes() != null && t.getTypes().getPcsc() != null && t.getTypes().getPcsc().isEnabled()) {
                        LOG.debug((Object)"catch all terminal found: enabled, PC/SC configured and enabled");
                        catchAll = true;
                    } else if (t.isEnabled() && t.getTypes() != null && t.getTypes().getPcsc() != null && !t.getTypes().getPcsc().isEnabled()) {
                        LOG.debug((Object)"catch all terminal found: enabled, PC/SC disabled");
                        catchAll = false;
                    } else {
                        LOG.debug((Object)"catch all terminal found: disabled");
                    }
                    copyTerminalTypeList.remove(t);
                }
                ArrayList<String> copyPcscReaderList = new ArrayList<String>();
                copyPcscReaderList.addAll(pcscReaderList);
                block2: for (String name : pcscReaderList) {
                    for (TerminalType t : copyTerminalTypeList) {
                        if (!name.equals(t.getName()) && !name.startsWith(t.getName()) && (t.getTypes() == null || t.getTypes().getPcsc() == null || t.getTypes().getPcsc().getName() == null || !name.equals(t.getTypes().getPcsc().getName()) && !name.startsWith(t.getTypes().getPcsc().getName()))) continue;
                        if (!OCFBCSTerminalFactory.isTerminalTypeInternalUsed(t) && t.isEnabled() && t.getTypes().getPcsc().isEnabled()) {
                            LOG.debug((Object)("add: " + name));
                            JPCSCCardTerminalFactory.addInternalUsedTerminalType(t);
                            ctr.add(new JPCSCCardTerminal(name, "SHARED", t));
                            copyPcscReaderList.remove(name);
                            continue block2;
                        }
                        copyPcscReaderList.remove(name);
                    }
                }
                if (!copyPcscReaderList.isEmpty() && catchAll) {
                    LOG.debug((Object)("add all: " + copyPcscReaderList));
                    this.addAll(ctr, copyPcscReaderList);
                }
            } else {
                LOG.debug((Object)("add all (no terminals configured): " + pcscReaderList));
                this.addAll(ctr, pcscReaderList);
            }
        } else {
            LOG.debug((Object)("add all: " + pcscReaderList));
            this.addAll(ctr, pcscReaderList);
        }
    }

    private void addAll(CardTerminalRegistry ctr, List<String> pcscReaderList) throws CardTerminalException {
        for (String name : pcscReaderList) {
            JPCSCCardTerminal terminal = new JPCSCCardTerminal(name, "SHARED", null);
            ctr.add(terminal);
            ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).addTerminal(terminal);
        }
    }

    @Override
    public void open() throws CardTerminalException {
    }

    @Override
    public void close() throws CardTerminalException {
    }

    private static List<String> listReaders() {
        String[] readers = null;
        int retries = 3;
        while (readers == null && retries > 0) {
            try {
                long context = jpcsc.establishContext(0, null, null);
                readers = jpcsc.listReaders(context, null);
                jpcsc.releaseContext(context);
            }
            catch (NullPointerException npe) {
                --retries;
            }
            catch (PCSCException pcsce) {
                --retries;
            }
        }
        if (readers == null) {
            readers = new String[]{};
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(readers));
        return result;
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, UserConfigurationManager ucm, String[] terminalInfo, boolean onlyInitUserConfigurationManager) throws CardTerminalException, TerminalInitException {
        if (ucm == null) {
            try {
                ucm = DefaultUserConfigurationManager.getManager();
            }
            catch (IOException iOException) {}
        } else {
            JPCSCCardTerminalFactory.ucm = ucm;
        }
        if (onlyInitUserConfigurationManager) {
            return;
        }
        this.createCardTerminals(ctr, terminalInfo);
    }

    public static synchronized void addInternalUsedTerminalType(TerminalType tt) {
        if (tt != null && internalUsedTerminalTypeMap.containsKey(tt)) {
            internalUsedTerminalTypeMap.put(tt, internalUsedTerminalTypeMap.get(tt) + 1);
        } else if (tt != null && !internalUsedTerminalTypeMap.containsKey(tt)) {
            internalUsedTerminalTypeMap.put(tt, 1);
            OCFBCSTerminalFactory.addExternalUsedTerminalType(tt);
        }
    }

    public static synchronized void removeInternalUsedTerminalType(TerminalType tt) {
        if (tt != null && internalUsedTerminalTypeMap.containsKey(tt)) {
            if (internalUsedTerminalTypeMap.get(tt) == 1) {
                externalUsedTerminalTypeList.remove(tt);
                OCFBCSTerminalFactory.removeExternalUsedTerminalType(tt);
            } else {
                internalUsedTerminalTypeMap.put(tt, internalUsedTerminalTypeMap.get(tt) - 1);
            }
        }
    }

    public static synchronized boolean isTerminalTypeInternalUsed(TerminalType tt) {
        return internalUsedTerminalTypeMap.containsKey(tt);
    }

    public static synchronized void addExternalUsedTerminalType(TerminalType tt) {
        if (tt != null && !externalUsedTerminalTypeList.contains(tt)) {
            externalUsedTerminalTypeList.add(tt);
        }
    }

    public static synchronized void removeExternalUsedTerminalType(TerminalType tt) {
        if (tt != null && externalUsedTerminalTypeList.contains(tt)) {
            externalUsedTerminalTypeList.remove(tt);
        }
    }

    public static synchronized void clearUsedTerminalTypesList() {
        externalUsedTerminalTypeList.clear();
        internalUsedTerminalTypeMap.clear();
    }
}

