/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal.pcsc;

import de.bos_bremen.basecard.common.dialog.BTerminalDialog;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.impl.TerminalParametersImpl;
import de.bos_bremen.basecard.terminal.pcsc.PCSCTerminal;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.basecard.terminal.pcsc.impl.JPCSCTerminalImpl;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.jni.pcsc.PCSCException;
import de.bos_bremen.jni.pcsc.PCSCReaderState;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import de.bos_bremen.userconf.xml.SCDriverTypes;
import de.bos_bremen.userconf.xml.TerminalType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;

public class JPCSCCardTerminal
extends PCSCCardTerminal {
    private PCSCTerminal innerTerminal = null;

    protected JPCSCCardTerminal(String name, String address, TerminalType terminalType) throws CardTerminalException {
        super(name, SCDriverTypes.PCSC.name(), address, terminalType);
        this.innerTerminal = new JPCSCTerminalImpl(name);
        this.pcsc20features = this.innerTerminal.getFeatures();
        super.addSlots(1);
        this.itracer = new Tracer((Object)this, JPCSCCardTerminal.class);
    }

    @Override
    public synchronized PCSCReaderState getCardStatus(long cardHandle) throws CardTerminalException, IllegalStateException, IllegalArgumentException {
        try {
            return this.innerTerminal.getStatus();
        }
        catch (PCSCException e) {
            throw this.translatePcscException(e);
        }
    }

    @Override
    public synchronized PCSCReaderState getStatus(long contextHandle, int slot) throws CardTerminalException, IllegalStateException, IllegalArgumentException {
        PCSCReaderState readerState = null;
        try {
            readerState = this.innerTerminal.getStatusChange(slot);
        }
        catch (PCSCException e) {
            throw this.translatePcscException(e);
        }
        byte[] atr = readerState.getATR();
        if (atr != null && atr.length > 0) {
            this.cachedCardStatus = true;
            return readerState;
        }
        this.cachedCardStatus = false;
        return null;
    }

    @Override
    public long establishContext() throws PCSCException {
        return this.innerTerminal.establishContext();
    }

    @Override
    public void releaseContext(long extContextHandle) throws PCSCException, IllegalStateException, IllegalArgumentException {
        this.innerTerminal.releaseContext();
        this.cardHandle = 0L;
        this.shareMode = 0;
    }

    @Override
    public long connect(long contextHandle, int slotID, boolean exclusive) throws CardTerminalException, IllegalStateException {
        return this.connect(contextHandle, slotID, exclusive, null);
    }

    @Override
    public long connect(long contextHandle, int slotID, boolean exclusive, Protocol protocol) throws CardTerminalException, IllegalStateException {
        this.powerUpCard(slotID, 0, 0, exclusive, protocol);
        return this.cardHandle;
    }

    @Override
    public void disconnect(long extCardHandle, int disposition) throws CardTerminalException, IllegalStateException {
        this.cardDisconnect(disposition);
    }

    @Override
    public void cardDisconnect(int disposition) throws CardTerminalException, IllegalStateException {
        try {
            this.innerTerminal.disconnect(disposition);
        }
        catch (PCSCException e) {
            throw this.translatePcscException(e);
        }
        this.cardHandle = 0L;
        this.shareMode = 0;
    }

    @Override
    public boolean isConnected() {
        return !this.innerTerminal.isConnected();
    }

    @Override
    public boolean beginTransaction(long timeout) throws IllegalStateException {
        return this.innerTerminal.beginTransaction((int)timeout);
    }

    @Override
    public boolean beginTransaction(long cardHandle, long timeout) throws IllegalStateException {
        return this.innerTerminal.beginTransaction((int)timeout);
    }

    @Override
    public boolean endTransaction() throws IllegalStateException {
        return this.innerTerminal.endTransaction();
    }

    @Override
    public boolean endTransaction(long cardHandle) throws IllegalStateException {
        return this.innerTerminal.endTransaction();
    }

    @Override
    public boolean isTransactionLocked() {
        return this.innerTerminal == null ? false : this.innerTerminal.isTransactionLocked();
    }

    @Override
    public ResponseAPDU transmit(long cardHandle, int slotID, CommandAPDU capdu, int ms) throws CardTerminalException, IllegalStateException, IllegalArgumentException {
        if (capdu == null) {
            throw new IllegalArgumentException("command must not be null");
        }
        byte[] responseBytes = null;
        try {
            responseBytes = this.innerTerminal.transmit(capdu.getBytes());
        }
        catch (PCSCException e) {
            throw this.translatePcscException(e);
        }
        return new ResponseAPDU(responseBytes);
    }

    @Override
    protected ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException, IllegalStateException, IllegalArgumentException {
        if (this.cardHandle == 0L) {
            this.powerUpCard(0, 0);
        }
        return this.transmit(0L, slot, capdu, ms);
    }

    @Override
    public byte[] sendTerminalCommand(int controlCode, byte[] cmd) throws CardTerminalException, IllegalStateException {
        byte[] response = null;
        try {
            response = this.innerTerminal.sendTerminalCommand(controlCode, cmd);
        }
        catch (PCSCException e) {
            throw this.translatePcscException(e);
        }
        if (response == null) {
            throw new CardTerminalException("No response from reader", this);
        }
        return response;
    }

    @Override
    public byte[] sendTerminalCommand(byte[] cmd) throws CardTerminalException, IllegalStateException {
        return this.sendTerminalCommand(0, cmd);
    }

    @Override
    public void resetSlot(int slotID) throws CardTerminalException, IllegalStateException {
        if (this.cachedCardStatus && this.cardHandle != 0L) {
            try {
                this.innerTerminal.disconnect(2);
                this.cardHandle = this.innerTerminal.connect(this.shareMode == 1);
            }
            catch (PCSCException e) {
                throw this.translatePcscException(e);
            }
        }
    }

    @Override
    public void open() throws CardTerminalException {
        try {
            this.establishContext();
        }
        catch (PCSCException e) {
            throw this.translatePcscException(e);
        }
        CardTerminalRegistry.getRegistry().addPollable(this);
        this.closed = false;
    }

    @Override
    public void close() throws CardTerminalException {
        if (!this.closed) {
            this.closed = true;
            this.removePollable();
            boolean cardPresent = this.cachedCardStatus;
            if (cardPresent) {
                super.cardRemoved(0);
            }
            if (this.innerTerminal.isTransactionLocked()) {
                try {
                    this.endTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isConnected()) {
                this.cid = null;
                this.cardDisconnect(0);
            }
        } else {
            throw new CardTerminalException("JPCSCCardTerminal: already closed");
        }
        if (this.innerTerminal instanceof JPCSCTerminalImpl) {
            ((JPCSCTerminalImpl)this.innerTerminal).destroy();
        }
        this.innerTerminal = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePollable() {
        JPCSCCardTerminal jPCSCCardTerminal = this;
        synchronized (jPCSCCardTerminal) {
            CardTerminalRegistry.getRegistry().removePollable(this);
        }
    }

    @Override
    protected CardID internalReset(int slot, int ms) throws CardTerminalException {
        if (this.cachedCardStatus) {
            this.cid = null;
            PCSCReaderState readerState = null;
            try {
                if (this.cardHandle != 0L) {
                    this.innerTerminal.disconnect(1);
                }
                this.connect(this.shareMode == 1, null);
            }
            catch (PCSCException e) {
                throw this.translatePcscException(e);
            }
            readerState = this.getStatus(0L, 0);
            if (readerState.getATR() == null) {
                throw new CardTerminalException("No ATR present. Card badly inserted? ", this);
            }
            this.cid = new CardID(this, 0, readerState.getATR());
            return this.cid;
        }
        return null;
    }

    @Override
    public synchronized void poll() throws CardTerminalException, IllegalStateException {
        if (!this.closed) {
            PCSCReaderState readerState = this.getStatus(this.innerTerminal.getCurrentContextHandle(), 0);
            try {
                boolean newStatus = this.isCardPresent(0);
                if (this.cardInserted != newStatus) {
                    this.cardInserted = newStatus;
                    if (this.cardInserted) {
                        this.cid = new CardID(this, 0, readerState.getATR());
                        this.cardInserted(0);
                    } else {
                        super.cardRemoved(0);
                        this.cid = null;
                    }
                }
            }
            catch (CardTerminalException cardterminalexception) {
                cardterminalexception.printStackTrace();
                super.cardInserted(0);
            }
        }
    }

    @Override
    public byte[] powerUpCard(int slotID, int timeout, int k, Boolean exclusive) throws CardTerminalException {
        return this.powerUpCard(slotID, timeout, k, exclusive, null);
    }

    @Override
    public byte[] powerUpCard(int slotID, int timeout, int k, Boolean exclusive, Protocol protocol) throws CardTerminalException {
        if (this.cachedCardStatus) {
            try {
                if (this.cardHandle != 0L) {
                    this.disconnect(0L, 2);
                }
                if (exclusive != null) {
                    this.connect(exclusive, protocol);
                } else {
                    this.connect(false, protocol);
                }
                if (this.cid == null) {
                    PCSCReaderState readerState = this.getStatus(0L, 0);
                    if (readerState == null || readerState.getATR() == null) {
                        throw new CardTerminalException("No ATR present. Card badly inserted? ", this);
                    }
                    this.cid = new CardID(this, 0, readerState.getATR());
                }
            }
            catch (PCSCException e) {
                this.cid = null;
                throw this.translatePcscException(e);
            }
        }
        return null;
    }

    @Override
    protected void cardInserted(int slotID) {
        if (this.pcsc20features == null || this.pcsc20features == Pcsc20Features.NO_FEATURES_CREATED) {
            this.pcsc20features = this.innerTerminal.getFeatures();
        }
        super.cardInserted(slotID);
    }

    CardTerminalException translatePcscException(PCSCException pcscexception) {
        return new CardTerminalException("JPCSCCardTerminal: " + pcscexception.getMessage(), this);
    }

    private long connect(boolean exclusive, Protocol protocol) throws PCSCException, IllegalStateException {
        this.cardHandle = this.innerTerminal.connect(exclusive, protocol);
        this.shareMode = exclusive ? 1 : 2;
        return this.cardHandle;
    }

    public byte[] pinOperation(BTerminalDialog chvDialog, PinVerifyParameters pvp) throws IllegalArgumentException, BTerminalException {
        return this.innerTerminal.processCommand(0, null, new TerminalParametersImpl(chvDialog, pvp, null)).getRaw();
    }
}

