/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal.bcs;

import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.bcs.BCSTerminal;
import de.bos_bremen.basecard.terminal.bcs.CardTerminalManufacturerDO;
import de.bos_bremen.basecard.terminal.bcs.impl.JCTAPITerminalImpl;
import de.bos_bremen.basecard.terminal.bcs.impl.JCTAPITerminalInfoImpl;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.common.system.VersionEnum;
import de.bos_bremen.java.ctapi.JCTAPI;
import de.bos_bremen.java.ctapi.JCTAPIConnectionManager;
import de.bos_bremen.java.ctapi.JCTAPILibraryManager;
import de.bos_bremen.java.ctapi.impl.JCTAPIFactoryImpl;
import de.bos_bremen.jni.ctapi.CTAPIException;
import de.bos_bremen.opencard.terminal.SubCardTerminalFactory;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSClass1Terminal;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSClass3Terminal;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminalFactory;
import de.bos_bremen.userconf.UserConfigurationManager;
import de.bos_bremen.userconf.impl.DefaultUserConfigurationManager;
import de.bos_bremen.userconf.xml.CTAPISetType;
import de.bos_bremen.userconf.xml.CTAPISetTypes;
import de.bos_bremen.userconf.xml.CTAPIType;
import de.bos_bremen.userconf.xml.DriverType;
import de.bos_bremen.userconf.xml.DriversType;
import de.bos_bremen.userconf.xml.LibraryType;
import de.bos_bremen.userconf.xml.NativeArchType;
import de.bos_bremen.userconf.xml.NativeOSType;
import de.bos_bremen.userconf.xml.NativeType;
import de.bos_bremen.userconf.xml.SCConfiguration;
import de.bos_bremen.userconf.xml.SCDriverTypes;
import de.bos_bremen.userconf.xml.TerminalType;
import de.bos_bremen.userconf.xml.TerminalsType;
import de.bos_bremen.userconf.xml.Types;
import de.bos_bremen.userconf.xml.UserConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OCFBCSTerminalFactory
implements SubCardTerminalFactory {
    private static JCTAPILibraryManager manager = JCTAPILibraryManager.getLibraryManager();
    private static Map<String, Long> libraryMap = new HashMap<String, Long>();
    private static List<Long> listUsedHandles = new ArrayList<Long>();
    private static final String SYSTEM_PROPERTY_ARCHITECTURE = "sun.arch.data.model";
    private static final int START_SIG_IDX_OS_NAME = 0;
    private static final int END_SIG_IDX_OS_NAME = 3;
    private static final int START_SIG_IDX_ARCH = 0;
    private static final int END_SIG_IDX_ARCH = 2;
    private static final Log LOG = LogFactory.getLog(OCFBCSTerminalFactory.class);
    private static UserConfigurationManager ucm = null;
    private static Map<TerminalType, Integer> internalUsedTerminalTypeMap = new HashMap<TerminalType, Integer>();
    private static List<TerminalType> externalUsedTerminalTypeList = new ArrayList<TerminalType>();

    @Override
    public void open() throws CardTerminalException {
        LOG.debug((Object)"open OCFBCSTerminalFactory...");
    }

    @Override
    public void close() throws CardTerminalException {
        LOG.debug((Object)"close OCFBCSTerminalFactory...");
        for (Long handle : libraryMap.values()) {
            try {
                manager.unloadLibrary(handle);
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)("error unloading library, illegal state: " + e.getMessage()));
            }
            catch (CTAPIException e) {
                LOG.debug((Object)("error unloading library: " + e.getMessage()));
            }
        }
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, UserConfigurationManager ucm, String[] terminalInfo, boolean onlyInitUserConfigurationManager) throws CardTerminalException, TerminalInitException {
        if (ucm == null) {
            try {
                ucm = DefaultUserConfigurationManager.getManager();
            }
            catch (IOException iOException) {}
        } else {
            OCFBCSTerminalFactory.ucm = ucm;
        }
        if (onlyInitUserConfigurationManager) {
            return;
        }
        this.createCardTerminals(ctr, terminalInfo);
    }

    @Override
    public synchronized void createCardTerminals(CardTerminalRegistry ctr, String[] terminalInfo) throws CardTerminalException, TerminalInitException {
        LOG.debug((Object)"OCFBCSTerminalFactory.createCardTerminals()...");
        listUsedHandles.clear();
        UserConfiguration uc = ucm.getConfiguration();
        SCConfiguration scConfiguration = uc.getSmartcard();
        DriversType driver = scConfiguration.getDrivers();
        List<DriverType> listDrivers = driver.getDriver();
        if (listDrivers == null || listDrivers.isEmpty()) {
            return;
        }
        boolean ctapiEnabled = false;
        for (DriverType dt : driver.getDriver()) {
            if (dt.getName() != SCDriverTypes.CTAPI || !dt.isEnabled()) continue;
            ctapiEnabled = true;
            break;
        }
        if (!ctapiEnabled) {
            return;
        }
        SystemEnum currentSystem = SystemEnum.getCurrentSystem();
        String currentOS = currentSystem.getName().toLowerCase().substring(0, 3);
        int currentArch = Integer.valueOf(System.getProperties().get(SYSTEM_PROPERTY_ARCHITECTURE).toString().substring(0, 2));
        TerminalsType scTt = scConfiguration.getTerminals();
        if (scTt.getTerminal() == null || scTt.getTerminal().isEmpty()) {
            return;
        }
        for (TerminalType tt : scTt.getTerminal()) {
            CTAPISetTypes cst;
            CTAPIType ct;
            Types t;
            if (!tt.isEnabled() || (t = tt.getTypes()) == null || JPCSCCardTerminalFactory.isTerminalTypeInternalUsed(tt) || (ct = t.getCtapi()) == null || !ct.isEnabled() || (cst = ct.getSets()) == null || cst.getSet() == null || cst.getSet().isEmpty()) continue;
            for (CTAPISetType st : cst.getSet()) {
                if (st == null || !st.isEnabled() || st.getNative() == null || st.getNative().getRef() == null || st.getNative().getRef().isEmpty()) continue;
                for (Object ont : st.getNative().getRef()) {
                    NativeType nt;
                    if (!NativeType.class.isInstance(ont) || (nt = (NativeType)NativeType.class.cast(ont)) == null || nt.getOs() == null || nt.getOs().isEmpty()) continue;
                    for (NativeOSType not : nt.getOs()) {
                        if (not == null || not.getName() == null || not.getName().length() < 3 || !currentOS.equals(not.getName().substring(0, 3).toLowerCase()) || not.getArch() == null || not.getArch().isEmpty()) continue;
                        for (NativeArchType nat : not.getArch()) {
                            LibraryType lt;
                            if (nat == null || currentArch != nat.getType() || (lt = nat.getLibrary()) == null || lt.getName() == null || lt.getName().length() <= 0) continue;
                            try {
                                this.connectTerminal(currentSystem, tt, ct, cst, st, nt, not, nat, lt);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
        for (Long handle : libraryMap.values()) {
            if (!JCTAPIConnectionManager.getConnectionManager().getConnectionList(handle).isEmpty()) continue;
            try {
                libraryMap.remove(handle);
                manager.unloadLibrary(handle);
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)("error unloading library, illegal state: " + e.getMessage()));
            }
            catch (CTAPIException e) {
                LOG.debug((Object)("error unloading library: " + e.getMessage()));
            }
        }
        for (Long handle : libraryMap.values()) {
            listUsedHandles.add(handle);
        }
    }

    public static final List<Long> getListUsedHandles() {
        return Collections.unmodifiableList(listUsedHandles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectTerminal(SystemEnum currentSystem, TerminalType tt, CTAPIType ct, CTAPISetTypes cst, CTAPISetType st, NativeType nt, NativeOSType not, NativeArchType nat, LibraryType lt) {
        long libraryHandle = -1L;
        if (!libraryMap.containsKey(lt.getName())) {
            if (!new File(lt.getName()).exists()) {
                LOG.debug((Object)("library not found: " + lt.getName()));
                return;
            }
            try {
                libraryHandle = manager.loadLibrary(lt.getName());
                if (libraryHandle == -1L) {
                    return;
                }
                libraryMap.put(lt.getName(), libraryHandle);
            }
            catch (CTAPIException e) {
                LOG.debug((Object)("loading library failed: " + lt.getName() + ", message: " + e.getMessage()));
            }
        } else {
            libraryHandle = libraryMap.get(lt.getName());
        }
        boolean error = false;
        BCSTerminal terminal = null;
        try {
            JCTAPITerminalInfoImpl jterminalInfo = new JCTAPITerminalInfoImpl(libraryHandle, st.getTerminalNo(), st.getPort());
            JCTAPI jctapi = (JCTAPI)JCTAPIFactoryImpl.getFactory().getImplementation(VersionEnum.VERSION_1_0.ordinal());
            terminal = new JCTAPITerminalImpl(jterminalInfo, jctapi);
            LOG.debug((Object)("connecting to terminal '" + tt.getName() + "' using library '" + lt.getName() + "' with terminalNo '" + st.getTerminalNo() + "' and port '" + st.getPort() + "'"));
            terminal.connect();
            CardTerminalManufacturerDO ctmd = terminal.getManufacturerData();
            LOG.debug((Object)ctmd);
            List<Integer> fus = terminal.getFunctionalUnitList();
            LOG.debug(fus);
            int terminalClass = 0;
            terminalClass = terminal.isDisplayPresent() && terminal.isKeyboardPresent() ? 3 : (!terminal.isDisplayPresent() && terminal.isKeyboardPresent() ? 2 : 1);
            CardTerminal oct = null;
            switch (terminalClass) {
                case 2: 
                case 3: {
                    oct = new OCFBCSClass3Terminal(tt.getName(), String.valueOf(st.getPort()), terminal);
                    break;
                }
                case 1: {
                    oct = new OCFBCSClass1Terminal(tt.getName(), String.valueOf(st.getPort()), terminal);
                    break;
                }
            }
            oct.open();
            JPCSCCardTerminalFactory.addExternalUsedTerminalType(tt);
            error = false;
            return;
        }
        catch (BTerminalException e) {
            LOG.debug((Object)("BTerminalException:" + tt.getName() + " (" + e.getCause() + ")"));
            error = true;
            return;
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)("BTerminalException:" + tt.getName() + " (" + e.getCause() + ")"));
            error = true;
            return;
        }
        finally {
            if (error && terminal != null && terminal.isConnected()) {
                try {
                    terminal.disconnect();
                }
                catch (BTerminalException e) {
                    LOG.debug((Object)("BTerminalException:" + tt.getName() + " (" + e.getCause() + ")"));
                }
            }
        }
    }

    public static synchronized void addInternalUsedTerminalType(TerminalType tt) {
        if (tt != null && internalUsedTerminalTypeMap.containsKey(tt)) {
            internalUsedTerminalTypeMap.put(tt, internalUsedTerminalTypeMap.get(tt) + 1);
        } else if (tt != null && !internalUsedTerminalTypeMap.containsKey(tt)) {
            internalUsedTerminalTypeMap.put(tt, 1);
            JPCSCCardTerminalFactory.addExternalUsedTerminalType(tt);
        }
    }

    public static synchronized void removeInternalUsedTerminalType(TerminalType tt) {
        if (tt != null && internalUsedTerminalTypeMap.containsKey(tt)) {
            if (internalUsedTerminalTypeMap.get(tt) == 1) {
                externalUsedTerminalTypeList.remove(tt);
                JPCSCCardTerminalFactory.removeExternalUsedTerminalType(tt);
            } else {
                internalUsedTerminalTypeMap.put(tt, internalUsedTerminalTypeMap.get(tt) - 1);
            }
        }
    }

    public static synchronized boolean isTerminalTypeInternalUsed(TerminalType tt) {
        return internalUsedTerminalTypeMap.containsKey(tt);
    }

    public static synchronized void addExternalUsedTerminalType(TerminalType tt) {
        if (tt != null && !externalUsedTerminalTypeList.contains(tt)) {
            externalUsedTerminalTypeList.add(tt);
        }
    }

    public static synchronized void removeExternalUsedTerminalType(TerminalType tt) {
        if (tt != null && externalUsedTerminalTypeList.contains(tt)) {
            externalUsedTerminalTypeList.remove(tt);
        }
    }

    public static synchronized void clearUsedTerminalTypesList() {
        externalUsedTerminalTypeList.clear();
    }
}

