/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal.bcs;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.dialog.BEnhancedTerminalDialog;
import de.bos_bremen.basecard.common.dialog.BTerminalDialog;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.impl.CommandImpl;
import de.bos_bremen.basecard.terminal.BSecureTerminal;
import de.bos_bremen.basecard.terminal.BTerminalCancelledException;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.BTerminalTimeoutException;
import de.bos_bremen.basecard.terminal.TerminalParameters;
import de.bos_bremen.basecard.terminal.bcs.BCSTerminal;
import de.bos_bremen.gov2.jca_provider.ocf.cards.EnhancedGovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVControl;
import de.bos_bremen.opencard.terminal.OCFBSecureTerminal;
import de.bos_bremen.opencard.terminal.bcs.AbstractOCFBCSTerminal;
import java.util.Arrays;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import opencard.opt.terminal.UserInteraction;

public class OCFBCSClass3Terminal
extends AbstractOCFBCSTerminal
implements UserInteraction,
VerifiedAPDUInterface,
OCFBSecureTerminal {
    private static final byte[] ERROR_CODE_FU_UNABLE_TO_PARSE_OUTPUT_DATA = new byte[]{100, 16};

    public OCFBCSClass3Terminal(String name, String address, BCSTerminal terminal) throws CardTerminalException {
        super(name, address, terminal);
    }

    @Override
    public synchronized void clearDisplay() {
        this.display(" ");
    }

    @Override
    public void display(String message) {
        try {
            super.checkConnected();
            this.terminal.output(message, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String keyboardInput(CardTerminalIOControl ioControl) {
        return this.promptUser("Input:\n", ioControl);
    }

    @Override
    public String promptUser(String prompt, CardTerminalIOControl ioControl) {
        String result = null;
        try {
            super.checkConnected();
            Response r = this.terminal.input(80, 2, prompt, ioControl.timeout(), ioControl.maxInputChars());
            result = new String(r.getData());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public ResponseAPDU sendVerifiedCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc, int ms) throws CardTerminalException {
        return this.sendVerifiedCommandAPDU(chann, capdu, vc);
    }

    @Override
    public ResponseAPDU sendVerifiedCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc) throws CardTerminalException {
        if (GovCHVControl.class.isInstance(vc)) {
            return this.processCommand(chann.getSlotNumber(), capdu, ((GovCHVControl)GovCHVControl.class.cast(vc)).getTerminalParameters());
        }
        ResponseAPDU result = null;
        try {
            super.checkConnected();
            super.checkSlotExists(chann.getSlotNumber());
            Command cardCommand = AbstractOCFBCSTerminal.convert(capdu);
            String promptMsg = vc.prompt();
            int pinLength = vc.ioControl().maxInputChars();
            int pinCoding = 0;
            if ("BCD Encoding".equals(vc.passwordEncoding())) {
                pinCoding = 0;
            } else if ("T.50 Encoding".equals(vc.passwordEncoding())) {
                pinCoding = 1;
            } else if ("Format 2 Pin Block Encoding".equals(vc.passwordEncoding())) {
                pinCoding = 2;
            } else {
                throw new IllegalArgumentException("not supported PIN encoding: " + vc.passwordEncoding());
            }
            int icc = chann.getSlotNumber() + 1;
            Response response = null;
            Integer responseBufferSize = OCFBCSClass3Terminal.getResponseBufferSize(capdu);
            if (capdu.getBytes()[1] != 32) {
                throw new CardTerminalException("modification not supported, use GOVCHVControl with TerminalParameters instead");
            }
            response = this.terminal.performVerification(icc, 0, pinLength, pinCoding, vc.passwordOffset(), cardCommand, promptMsg, null, null, vc.ioControl().timeout(), responseBufferSize);
            result = AbstractOCFBCSTerminal.convert(response);
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (Exception e) {
            throw OCFBCSClass3Terminal.mapException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processCommand(int slot, Command cardCommand, TerminalParameters terminalParameters) throws BTerminalException, BTerminalTimeoutException, BTerminalCancelledException {
        super.checkConnected();
        super.checkSlotExists(slot);
        if (BSecureTerminal.class.isInstance(this.terminal)) {
            return ((BSecureTerminal)BSecureTerminal.class.cast(this.terminal)).processCommand(slot, cardCommand, terminalParameters);
        }
        BTerminalDialog dialog = terminalParameters.getDialog();
        EnhancedGovCHVDialog govDialog = (EnhancedGovCHVDialog)EnhancedGovCHVDialog.class.cast(dialog);
        PinVerifyParameters pinParameters = terminalParameters.getPinParameters();
        BDialogMode mode = BDialogMode.CARD_VERIFY;
        if (BEnhancedTerminalDialog.class.isInstance(dialog)) {
            mode = ((BEnhancedTerminalDialog)BEnhancedTerminalDialog.class.cast(dialog)).getMode();
        }
        Response result = null;
        Integer responseBufferSize = OCFBCSClass3Terminal.getResponseBufferSize(cardCommand);
        int pinLength = 0;
        int timeout = pinParameters.getSecondTimeout();
        int pinCoding = 0;
        int passwordOffset = 6;
        if (pinParameters.getMaxPinLength() != -1 && pinParameters.getMaxPinLength() == pinParameters.getMinPinLength()) {
            pinLength = pinParameters.getMaxPinLength();
        }
        if ("BCD Encoding".equals(pinParameters.getEncoder().getName())) {
            pinCoding = 0;
        } else if ("T.50 Encoding".equals(pinParameters.getEncoder().getName())) {
            pinCoding = 1;
        } else if ("Format 2 Pin Block Encoding".equals(pinParameters.getEncoder().getName())) {
            pinCoding = 2;
        } else {
            throw new IllegalArgumentException("not supported PIN encoding: " + pinParameters.getEncoder().getName());
        }
        Object monitor = null;
        try {
            monitor = govDialog.showReaderMessage();
            int icc = slot + 1;
            if (mode == BDialogMode.CARD_VERIFY) {
                try {
                    result = this.terminal.performVerification(icc, 0, pinLength, pinCoding, passwordOffset, cardCommand, terminalParameters.getPrompt(), null, null, timeout, responseBufferSize);
                }
                catch (BTerminalException e) {
                    if (!Arrays.equals(ERROR_CODE_FU_UNABLE_TO_PARSE_OUTPUT_DATA, e.getResponse().getCode()) && terminalParameters.getPrompt() != null && (terminalParameters.getPrompt().contains("\r") || terminalParameters.getPrompt().contains("\n"))) {
                        throw e;
                    }
                    result = this.terminal.performVerification(icc, 0, pinLength, pinCoding, passwordOffset, cardCommand, terminalParameters.getPrompt().replaceAll("\r", "").replaceAll("\n", ""), null, null, timeout, responseBufferSize);
                }
            } else {
                int secondPasswordOffset = 14;
                try {
                    result = this.terminal.modifyVerificationData(icc, 0, pinLength, pinCoding, passwordOffset, secondPasswordOffset, cardCommand, terminalParameters.getPrompt(), null, null, null, null, null, timeout, responseBufferSize);
                }
                catch (BTerminalException e) {
                    if (!Arrays.equals(ERROR_CODE_FU_UNABLE_TO_PARSE_OUTPUT_DATA, e.getResponse().getCode()) && terminalParameters.getPrompt() != null && (terminalParameters.getPrompt().contains("\r") || terminalParameters.getPrompt().contains("\n"))) {
                        throw e;
                    }
                    result = this.terminal.modifyVerificationData(icc, 0, pinLength, pinCoding, passwordOffset, secondPasswordOffset, cardCommand, terminalParameters.getPrompt().replaceAll("\r", "").replaceAll("\n", ""), null, null, null, null, null, timeout, responseBufferSize);
                }
            }
        }
        finally {
            govDialog.hideReaderMessage(monitor);
        }
        return result;
    }

    @Override
    public ResponseAPDU processCommand(int slot, CommandAPDU cardCommand, TerminalParameters terminalParameters) throws CardTerminalException {
        ResponseAPDU result = null;
        try {
            this.checkConnected();
            this.checkSlotExists(slot);
            CommandImpl c = new CommandImpl(cardCommand.getBytes());
            Response r = this.processCommand(slot, c, terminalParameters);
            result = AbstractOCFBCSTerminal.convert(r);
            return result;
        }
        catch (BTerminalException e) {
            throw OCFBCSClass3Terminal.mapException(e);
        }
    }
}

