/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal.bcs;

import de.bos_bremen.basecard.Command;
import de.bos_bremen.basecard.Response;
import de.bos_bremen.basecard.impl.CommandImpl;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.bcs.BCSTerminal;
import de.bos_bremen.basecard.terminal.bcs.ICCStatusDO;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.userconf.xml.SCDriverTypes;
import java.util.ArrayList;
import java.util.List;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.Pollable;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOCFBCSTerminal
extends CardTerminal
implements Pollable {
    private static final Log log = LogFactory.getLog(AbstractOCFBCSTerminal.class);
    private List<CardID> cardIDList = null;
    private List<Integer> fuList = null;
    private List<ICCStatusDO> iccStatusList = null;
    private boolean ignoreOpenClose = false;
    protected BCSTerminal terminal = null;

    public static Command convert(CommandAPDU command) {
        return new CommandImpl(command.getBytes());
    }

    public static ResponseAPDU convert(Response response) {
        return new ResponseAPDU(response.getRaw());
    }

    protected static CardTerminalException mapException(Exception e) {
        CardTerminalException cte = new CardTerminalException(e.getMessage());
        cte.initCause(e);
        return cte;
    }

    public BCSTerminal getBCSTerminal() {
        return this.terminal;
    }

    public void connect() throws CardTerminalException {
        if (this.terminal != null) {
            try {
                this.terminal.connect();
            }
            catch (BTerminalException e) {
                throw AbstractOCFBCSTerminal.mapException(e);
            }
        }
    }

    public final void disconnect() throws CardTerminalException {
        if (this.terminal != null) {
            try {
                this.terminal.disconnect();
            }
            catch (BTerminalException e) {
                throw AbstractOCFBCSTerminal.mapException(e);
            }
        }
    }

    public final boolean isConnected() {
        return this.terminal.isConnected();
    }

    public AbstractOCFBCSTerminal(String name, String address, BCSTerminal terminal) throws CardTerminalException {
        super(name, SCDriverTypes.CTAPI.name(), address);
        this.terminal = terminal;
        try {
            this.checkConnected();
            this.fuList = this.terminal.getFunctionalUnitList();
            super.addSlots(this.terminal.getICCUnitList().size());
        }
        catch (IllegalStateException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
        catch (BTerminalException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
    }

    @Override
    public final void close() throws CardTerminalException {
        this.updateRegistry(false);
        if (this.terminal.isConnected()) {
            try {
                log.debug((Object)("disconnecting " + this.getName()));
                this.terminal.disconnect();
                log.debug((Object)"...disconnected");
            }
            catch (BTerminalException e) {
                throw AbstractOCFBCSTerminal.mapException(e);
            }
        }
    }

    @Override
    public final synchronized CardID getCardID(int slotID) throws CardTerminalException {
        try {
            this.checkConnected();
            this.checkSlotExists(slotID);
            CardID result = this.cardIDList.get(slotID);
            if (result == null) {
                result = this.internalReset(slotID, 2000);
                this.cardIDList.set(slotID, result);
            }
            return result;
        }
        catch (BTerminalException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
    }

    @Override
    public final synchronized boolean isCardPresent(int slotID) throws CardTerminalException {
        try {
            this.checkConnected();
            this.checkSlotExists(slotID);
            ICCStatusDO is = this.iccStatusList.get(slotID);
            return is.isPresent();
        }
        catch (BTerminalException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
    }

    @Override
    public final synchronized void open() throws CardTerminalException {
        if (this.ignoreOpenClose) {
            return;
        }
        if (!this.terminal.isConnected()) {
            try {
                log.debug((Object)("connecting " + this.getName()));
                this.terminal.connect();
                log.debug((Object)"connected");
            }
            catch (BTerminalException e) {
                throw AbstractOCFBCSTerminal.mapException(e);
            }
        }
        try {
            this.iccStatusList = this.terminal.getICCStatusList();
            this.cardIDList = new ArrayList<CardID>(this.iccStatusList.size());
            for (ICCStatusDO is : this.iccStatusList) {
                if (!is.isPresent()) continue;
                super.cardInserted(is.getICC() - 1);
            }
            for (int i = 0; i < this.iccStatusList.size(); ++i) {
                this.cardIDList.add(null);
            }
        }
        catch (BTerminalException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
        this.updateRegistry(true);
    }

    @Override
    public final synchronized void poll() throws CardTerminalException {
        if (this.terminal.isConnected()) {
            try {
                List<ICCStatusDO> lastStatusList = this.iccStatusList;
                this.iccStatusList = this.terminal.getICCStatusList();
                ICCStatusDO tmpNew = null;
                ICCStatusDO tmpLast = null;
                for (int i = 0; i < this.iccStatusList.size(); ++i) {
                    if (i == 0) {
                        // empty if block
                    }
                    tmpNew = this.iccStatusList.get(i);
                    tmpLast = lastStatusList.get(i);
                    if (tmpNew.isPresent() == tmpLast.isPresent()) continue;
                    int slotID = tmpNew.getICC() - 1;
                    if (tmpNew.isPresent()) {
                        super.cardInserted(slotID);
                        continue;
                    }
                    super.cardRemoved(slotID);
                    this.cardIDList.set(slotID, null);
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (BTerminalException bTerminalException) {
                // empty catch block
            }
        }
    }

    private synchronized void updateRegistry(boolean add) throws CardTerminalException {
        if (this.ignoreOpenClose) {
            return;
        }
        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
        try {
            this.ignoreOpenClose = true;
            if (add) {
                ctr.add(this);
                ctr.addPollable(this);
            } else {
                ctr.remove(this);
                ctr.removePollable(this);
            }
        }
        finally {
            this.ignoreOpenClose = false;
        }
    }

    protected void checkConnected() throws BTerminalException {
        if (!this.terminal.isConnected()) {
            throw new BTerminalException("terminal not connected");
        }
    }

    protected void checkSlotExists(int slotID) throws BTerminalException {
        if (!this.fuList.contains(slotID + 1)) {
            throw new BTerminalException("slot " + slotID + " not exists");
        }
    }

    @Override
    protected final synchronized CardID internalReset(int slot, int ms) throws CardTerminalException {
        Response response = null;
        try {
            this.checkConnected();
            this.checkSlotExists(slot);
            int icc = slot + 1;
            response = !this.iccStatusList.get(slot).isPresent() ? this.terminal.requestICC(icc, 0, 1, null, 10) : this.terminal.resetICC(icc, 1);
        }
        catch (IllegalArgumentException icc) {
        }
        catch (IllegalStateException icc) {
        }
        catch (BTerminalException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
        CardID result = new CardID(this, slot, response.getData());
        return result;
    }

    @Override
    protected final ResponseAPDU internalSendAPDU(int slot, CommandAPDU capdu, int ms) throws CardTerminalException {
        Response response = null;
        try {
            this.checkConnected();
            this.checkSlotExists(slot);
            Integer responseBufferSize = AbstractOCFBCSTerminal.getResponseBufferSize(capdu);
            Command command = AbstractOCFBCSTerminal.convert(capdu);
            int icc = slot + 1;
            response = this.terminal.sendCardCommand(icc, command, responseBufferSize);
        }
        catch (IllegalArgumentException responseBufferSize) {
        }
        catch (IllegalStateException responseBufferSize) {
        }
        catch (BTerminalException e) {
            throw AbstractOCFBCSTerminal.mapException(e);
        }
        ResponseAPDU result = AbstractOCFBCSTerminal.convert(response);
        return result;
    }

    public static Integer getResponseBufferSize(CommandAPDU capdu) {
        GISOCommandAPDU gcapdu = null;
        gcapdu = GISOCommandAPDU.class.isInstance(capdu) ? (GISOCommandAPDU)GISOCommandAPDU.class.cast(capdu) : new GISOCommandAPDU(capdu.getBytes());
        Integer responseBufferSize = gcapdu.getLE();
        if (responseBufferSize == null) {
            responseBufferSize = 2;
        }
        if (responseBufferSize != null && responseBufferSize == 0) {
            responseBufferSize = gcapdu.isExtended() ? Integer.valueOf(65535) : Integer.valueOf(256);
        }
        return responseBufferSize;
    }

    public static Integer getResponseBufferSize(Command capdu) {
        return AbstractOCFBCSTerminal.getResponseBufferSize(new GISOCommandAPDU(capdu.getBytes()));
    }

    @Override
    public String getType() {
        String result = null;
        try {
            this.checkConnected();
            result = this.terminal.getManufacturerData().getCardTerminalType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

