/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal;

import de.bos_bremen.opencard.terminal.bcs.OCFBCSTerminalFactory;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminalFactory;
import de.bos_bremen.userconf.UserConfigurationManager;
import de.bos_bremen.userconf.impl.DefaultUserConfigurationManager;
import de.bos_bremen.userconf.impl.UserConfigurationManagerImpl;
import de.bos_bremen.userconf.xml.DriverType;
import de.bos_bremen.userconf.xml.DriversType;
import de.bos_bremen.userconf.xml.SCConfiguration;
import de.bos_bremen.userconf.xml.SCDriverTypes;
import de.bos_bremen.userconf.xml.UserConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.TerminalInitException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaCardTerminalFactory
implements CardTerminalFactory {
    private static final Log LOG = LogFactory.getLog(MetaCardTerminalFactory.class);

    @Override
    public void open() throws CardTerminalException {
    }

    @Override
    public void close() throws CardTerminalException {
    }

    @Override
    public void createCardTerminals(CardTerminalRegistry ctr, String[] terminalInfo) throws CardTerminalException, TerminalInitException {
        LOG.debug((Object)"MetaCardTerminalFactory.createCardTerminals()...");
        UserConfigurationManager ucm = null;
        if (terminalInfo == null || terminalInfo.length != 1) {
            try {
                ucm = DefaultUserConfigurationManager.getManager();
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)("loading configuration file failed, configuration does not exists - xml (configuration): " + UserConfigurationManager.DEFAULT_URL));
            }
            catch (IOException e) {
                LOG.debug((Object)("loading configuration file failed - xml (configuration) or xsd (schema) failed: " + e.getMessage()));
                LOG.debug((Object)("loading configuration file failed - xml (configuration): " + UserConfigurationManager.DEFAULT_URL));
                LOG.debug((Object)("loading configuration file failed - xsd (schema): " + UserConfigurationManager.XSD_URL));
            }
        } else if (terminalInfo.length == 1 && terminalInfo[0] != null) {
            try {
                ucm = new UserConfigurationManagerImpl(new URL(terminalInfo[0]));
            }
            catch (Exception e) {
                CardTerminalException cte = new CardTerminalException(e.getMessage());
                cte.initCause(e);
                throw cte;
            }
        }
        if (ucm == null) {
            try {
                new JPCSCCardTerminalFactory().createCardTerminals(ctr, null, terminalInfo, false);
            }
            catch (Throwable t) {
                LOG.debug((Object)("failed using PC/SC-factory: " + t.getMessage()));
            }
            return;
        }
        UserConfiguration uc = ucm.getConfiguration();
        SCConfiguration scConfiguration = uc.getSmartcard();
        DriversType driver = scConfiguration.getDrivers();
        List<DriverType> listDrivers = driver.getDriver();
        if (listDrivers == null || listDrivers.isEmpty()) {
            return;
        }
        ArrayList<DriverType> sortedListDrivers = new ArrayList<DriverType>();
        sortedListDrivers.addAll(listDrivers);
        Collections.sort(sortedListDrivers, new Comparator<DriverType>(){

            @Override
            public int compare(DriverType o1, DriverType o2) {
                Integer order1 = o1.getOrder();
                Integer order2 = o2.getOrder();
                if (order1 == null) {
                    order1 = Integer.MAX_VALUE;
                }
                if (order2 == null) {
                    order2 = Integer.MAX_VALUE;
                }
                if (order1 < order2) {
                    return -1;
                }
                if (order1 > order2) {
                    return 1;
                }
                return 0;
            }
        });
        new JPCSCCardTerminalFactory().createCardTerminals(ctr, ucm, null, true);
        new OCFBCSTerminalFactory().createCardTerminals(ctr, ucm, null, true);
        for (DriverType dt : sortedListDrivers) {
            if (dt.isEnabled() && SCDriverTypes.PCSC.equals((Object)dt.getName())) {
                try {
                    new JPCSCCardTerminalFactory().createCardTerminals(ctr, ucm, null, false);
                }
                catch (Throwable t) {
                    LOG.debug((Object)("failed using PC/SC-factory: " + t.getMessage()));
                }
                continue;
            }
            if (!dt.isEnabled() || !SCDriverTypes.CTAPI.equals((Object)dt.getName())) continue;
            try {
                new OCFBCSTerminalFactory().createCardTerminals(ctr, ucm, terminalInfo, false);
            }
            catch (Throwable t) {
                LOG.debug((Object)("failed using CTAPI-factory: " + t.getMessage()));
            }
        }
    }
}

