/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.opencard.terminal;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.opencard.terminal.BlockingPollable;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;

public class BlockingPollableHandlerThread
extends Thread {
    private final BlockingPollable blockingPollable;
    private BlockingPollableHandlerThreadState currentState = BlockingPollableHandlerThreadState.INIT;

    public BlockingPollableHandlerThread(BlockingPollable blockingPollable) throws IllegalArgumentException {
        super(BlockingPollableHandlerThread.class.getSimpleName() + BlockingPollableHandlerThread.getName(blockingPollable));
        AssertUtil.notNull(blockingPollable, "blockingPollable can not be null");
        this.blockingPollable = blockingPollable;
        this.start();
    }

    private static String getName(BlockingPollable blockingPollable) {
        if (blockingPollable instanceof CardTerminal) {
            return "-" + ((CardTerminal)((Object)blockingPollable)).getName();
        }
        return "";
    }

    public BlockingPollableHandlerThreadState getCurrentState() {
        return this.currentState;
    }

    public synchronized void setCurrentState(BlockingPollableHandlerThreadState state) {
        if (this.currentState == state) {
            return;
        }
        switch (this.currentState) {
            case WAIT: 
            case DISABLED: 
            case ENABLED: {
                break;
            }
            default: {
                return;
            }
        }
        switch (state) {
            case WAIT: 
            case INIT: {
                return;
            }
            case DISABLED: 
            case ENABLED: 
            case KILLED: {
                break;
            }
            case ACTIVE: {
                break;
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean loop = true;
        do {
            BlockingPollableHandlerThread blockingPollableHandlerThread = this;
            synchronized (blockingPollableHandlerThread) {
                this.currentState = BlockingPollableHandlerThreadState.WAIT;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            switch (this.currentState) {
                case KILLED: {
                    loop = false;
                    break;
                }
                case WAIT: 
                case DISABLED: 
                case INIT: {
                    break;
                }
                case ENABLED: {
                    this.currentState = BlockingPollableHandlerThreadState.WAIT;
                    break;
                }
                case ACTIVE: {
                    try {
                        this.blockingPollable.blockPoll();
                    }
                    catch (CardTerminalException cardTerminalException) {}
                }
            }
        } while (loop);
    }

    public static enum BlockingPollableHandlerThreadState {
        INIT,
        WAIT,
        ACTIVE,
        KILLED,
        DISABLED,
        ENABLED;

    }
}

