/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.pcsc;

import de.bos_bremen.jni.pcsc.EnhancedPCSCReaderState;
import java.math.BigInteger;

public class EnhancedPCSCReaderStateImpl
implements EnhancedPCSCReaderState {
    private static final int COUNTER_SHIFT = 16;
    private static final int STATE_MASK = 65535;
    private static final int STATE_CHANGED_INVERSE = -3;
    private static final int COUNTER_MASK = -65536;
    private byte[] atr = null;
    private int readerState = 1;
    private int currentState = 0;
    private int eventState = 0;
    private int protocolValue = -1;
    private int counter = 0;
    private String name = null;
    private Object applicationData = null;

    @Override
    public final int getProtocolValue() {
        return this.protocolValue;
    }

    @Override
    public final void setProtocolValue(int protocolValue) {
        this.protocolValue = protocolValue;
    }

    public EnhancedPCSCReaderStateImpl() {
    }

    public EnhancedPCSCReaderStateImpl(String name, int readerState, int currentState, int eventState, byte[] atr, int protocol) {
        this(name, null, readerState, currentState, eventState, atr, protocol);
    }

    public EnhancedPCSCReaderStateImpl(String name, Object applicationData, int readerState, int currentState, int eventState, byte[] atr, int protocolValue) {
        this.name = name;
        this.applicationData = applicationData;
        this.setReaderState(readerState);
        this.setCurrentState(currentState);
        this.setEventState(eventState);
        this.setATR(atr);
        this.setProtocolValue(protocolValue);
    }

    @Override
    public final byte[] getATR() {
        return this.atr;
    }

    @Override
    public final int getCurrentState() {
        return this.currentState;
    }

    @Override
    public final int getEventState() {
        return this.eventState;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Object getApplicationData() {
        return this.applicationData;
    }

    @Override
    public final void setATR(byte[] atrValue) {
        this.atr = atrValue;
    }

    @Override
    public final void setCurrentState(int currentState) {
        if ((currentState & 0xFFFF0000) > 65535) {
            this.counter = currentState >> 16;
        }
        this.currentState = currentState & 0xFFFFFFFD;
    }

    @Override
    public final void setEventState(int eventState) {
        if ((eventState & 0xFFFF0000) > 65535) {
            this.counter = eventState >> 16;
        }
        this.eventState = eventState;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public String toString() {
        String indent = "    ";
        return super.toString() + "\n" + indent + "name: " + this.name + "\n" + indent + "application data: " + this.applicationData + "\n" + indent + "reader state: " + Integer.toHexString(this.readerState) + "\n" + indent + "current state: " + Integer.toHexString(this.currentState) + "\n" + indent + "event state: " + Integer.toHexString(this.eventState) + "\n" + indent + "ATR: " + (this.atr != null && this.atr.length > 0 ? new BigInteger(this.atr).toString(16) : " - ") + "\n" + indent + "protocol value: " + this.protocolValue + "\n" + indent + "counter: " + this.counter;
    }

    @Override
    public int getReaderState() {
        return this.readerState;
    }

    @Override
    public void setReaderState(int readerState) {
        if ((readerState & 0xFFFF0000) > 65535) {
            this.readerState = readerState & 0xFFFF;
            this.counter = readerState >> 16;
        } else {
            this.readerState = readerState;
        }
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(int counter) {
        this.counter = counter;
    }
}

