/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.ctapi;

import de.bos_bremen.jni.ctapi.CTAPI;
import de.bos_bremen.jni.ctapi.CTAPIException;
import de.bos_bremen.jni.ctapi.CTAPILibraryManager;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CTAPILibraryManagerImpl
implements CTAPILibraryManager {
    private static CTAPILibraryManager singleton = null;
    private Map<String, Long> libraryNameHandleMap = new LinkedHashMap<String, Long>();
    private Map<Long, String> handleLibraryNameMap = new LinkedHashMap<Long, String>();

    private CTAPILibraryManagerImpl() {
    }

    public static synchronized CTAPILibraryManager getInstance() {
        if (singleton == null) {
            singleton = new CTAPILibraryManagerImpl();
        }
        return singleton;
    }

    @Override
    public synchronized long loadLibrary(String library) throws IllegalArgumentException, IllegalStateException, CTAPIException {
        if (library == null || library.length() == 0) {
            throw new IllegalArgumentException("no valid library name: null or empty String not permitted");
        }
        if (this.libraryNameHandleMap.containsKey(library)) {
            throw new IllegalStateException("library '" + library + "' already loaded, handle: " + this.libraryNameHandleMap.get(library));
        }
        long handle = -1L;
        try {
            handle = CTAPI.loadLibrary(library);
        }
        catch (CTAPIException e) {
            CTAPIException xe = new CTAPIException(e.getMethodName(), e.getMessage() + " (library: " + library + ")", e.getCode(), e.getSystemCode(), e.getNativeMessage(), e.getNativeStep());
            throw xe;
        }
        this.libraryNameHandleMap.put(library, handle);
        this.handleLibraryNameMap.put(handle, library);
        return handle;
    }

    @Override
    public synchronized void unloadLibrary(long libraryHandle) throws IllegalArgumentException, CTAPIException {
        if (!this.handleLibraryNameMap.containsKey(libraryHandle)) {
            throw new IllegalArgumentException("library handle '" + libraryHandle + "' unknown");
        }
        CTAPI.unloadLibrary(libraryHandle);
        this.libraryNameHandleMap.remove(this.handleLibraryNameMap.get(libraryHandle));
        this.handleLibraryNameMap.remove(libraryHandle);
    }

    @Override
    public synchronized int getLibraryCount() throws CTAPIException {
        return CTAPI.getLibraryCount();
    }

    @Override
    public synchronized int getFreeLibraryCount() throws CTAPIException {
        return CTAPI.getFreeLibraryCount();
    }

    @Override
    public synchronized int getMaximumLibraryCount() throws CTAPIException {
        return CTAPI.getMaximumLibraryCount();
    }

    @Override
    public String getLibraryName(long libraryHandle) throws IllegalArgumentException {
        if (!this.handleLibraryNameMap.containsKey(libraryHandle)) {
            throw new IllegalArgumentException("library handle '" + libraryHandle + "' unknown");
        }
        return this.handleLibraryNameMap.get(libraryHandle);
    }
}

