/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.callback.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.jni.NativeException;
import de.bos_bremen.jni.callback.ContextEnum;
import de.bos_bremen.jni.callback.PCSCMethodEnum;
import de.bos_bremen.jni.callback.Support;
import de.bos_bremen.jni.callback.impl.LinuxMacosPCSCCallbackHandler;
import de.bos_bremen.jni.pcsc.PCSCException;

public class WindowsPCSCCallbackHandler
extends LinuxMacosPCSCCallbackHandler {
    public WindowsPCSCCallbackHandler() {
        super(SystemEnum.WINDOWS_ALL, Support.ALL_VERSIONS_LIST, ListUtil.toList(new int[]{ContextEnum.PCSC.ordinal()}), Support.ALL_METHODS_LIST, Support.ALL_STEPS_LIST);
    }

    @Override
    public Object evaluate(int system, int version, int context, int method, int step, int code, String message) throws NativeException {
        if (code == 0) {
            return null;
        }
        if (method == PCSCMethodEnum.SCARD_RELEASE_CONTEXT.ordinal()) {
            WindowsPCSCCallbackHandler.checkReleaseContext(code, method);
        } else if (method == PCSCMethodEnum.SCARD_GET_ATTRIB.ordinal()) {
            WindowsPCSCCallbackHandler.checkGetAttrib(code, method);
        } else if (method == PCSCMethodEnum.SCARD_SET_ATTRIB.ordinal()) {
            WindowsPCSCCallbackHandler.checkSetAttrib(code, method);
        } else if (method == PCSCMethodEnum.SCARD_CONTROL.ordinal()) {
            WindowsPCSCCallbackHandler.checkControl(code, method);
        } else if (method == PCSCMethodEnum.SCARD_END_TRANSACTION.ordinal()) {
            WindowsPCSCCallbackHandler.checkEndTransaction(code, method);
        } else if (method == PCSCMethodEnum.SCARD_TRANSMIT.ordinal()) {
            WindowsPCSCCallbackHandler.checkTransmit(code, method);
        }
        return super.evaluate(system, version, context, method, step, code, message);
    }

    private static void checkReleaseContext(int code, int method) throws PCSCException {
        String methodName = WindowsPCSCCallbackHandler.determineMethodName(method);
        switch (code) {
            case 6: {
                throw new PCSCException(methodName, "releasing context failed", -2146435069L, code);
            }
        }
    }

    private static void checkGetAttrib(int code, int method) throws PCSCException {
        String methodName = WindowsPCSCCallbackHandler.determineMethodName(method);
        switch (code) {
            case 14: {
                throw new PCSCException(methodName, "requested attribute cannot be retrieved", -2146435071L, code);
            }
        }
    }

    private static void checkSetAttrib(int code, int method) throws PCSCException {
        String methodName = WindowsPCSCCallbackHandler.determineMethodName(method);
        switch (code) {
            case 50: {
                throw new PCSCException(methodName, "setting this attribute not supported", -2146435050L, code);
            }
        }
    }

    private static void checkControl(int code, int method) throws PCSCException {
        String methodName = WindowsPCSCCallbackHandler.determineMethodName(method);
        switch (code) {
            case 1: 
            case 31: 
            case 50: 
            case 87: {
                throw new PCSCException(methodName, "control code not supported for this reader", -2146435050L, code);
            }
        }
    }

    private static void checkEndTransaction(int code, int method) throws PCSCException {
        String methodName = WindowsPCSCCallbackHandler.determineMethodName(method);
        switch (code) {
            case 50: {
                throw new PCSCException(methodName, "not supported for this reader", -2146435055L, code);
            }
            case 6: {
                throw new PCSCException(methodName, "invalid handle", -2146435069L, code);
            }
        }
    }

    private static void checkTransmit(int code, int method) throws PCSCException {
        String methodName = WindowsPCSCCallbackHandler.determineMethodName(method);
        switch (code) {
            case 122: {
                throw new PCSCException(methodName, "insufficient buffer size", -2146435064L, code);
            }
        }
    }
}

