/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.callback.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.jni.NativeException;
import de.bos_bremen.jni.callback.AbstractCallbackHandler;
import de.bos_bremen.jni.callback.ContextEnum;
import de.bos_bremen.jni.callback.PCSCMethodEnum;
import de.bos_bremen.jni.callback.Support;
import de.bos_bremen.jni.pcsc.PCSCException;
import java.util.List;

public class LinuxMacosPCSCCallbackHandler
extends AbstractCallbackHandler {
    public LinuxMacosPCSCCallbackHandler(List<Integer> supportedSystemList, List<Integer> supportedVersionList, List<Integer> supportedContextList, List<Integer> supportedMethodList, List<Integer> supportedStepList) {
        super(supportedSystemList, supportedVersionList, supportedContextList, supportedMethodList, supportedStepList);
    }

    public LinuxMacosPCSCCallbackHandler() {
        super(ListUtil.toList(new int[]{SystemEnum.LINUX.ordinal(), SystemEnum.MACOS.ordinal()}), Support.ALL_VERSIONS_LIST, ListUtil.toList(new int[]{ContextEnum.PCSC.ordinal()}), Support.ALL_METHODS_LIST, Support.ALL_STEPS_LIST);
    }

    @Override
    public Object evaluate(int system, int version, int context, int method, int step, int code, String message) throws NativeException {
        if (code == 0) {
            return null;
        }
        PCSCMethodEnum methodEnum = PCSCMethodEnum.valueOf(method);
        switch (methodEnum) {
            case SCARD_ESTABLISH_CONTEXT: {
                LinuxMacosPCSCCallbackHandler.checkEstablishContext(method, code);
                break;
            }
            case SCARD_RELEASE_CONTEXT: {
                LinuxMacosPCSCCallbackHandler.checkReleaseContext(method, code);
                break;
            }
            case SCARD_IS_VALID_CONTEXT: {
                LinuxMacosPCSCCallbackHandler.checkIsValidContext(method, code);
                break;
            }
            case SCARD_LIST_READER_GROUPS: {
                LinuxMacosPCSCCallbackHandler.checkListReaderGroups(method, step, code);
                break;
            }
            case SCARD_LIST_READERS: {
                LinuxMacosPCSCCallbackHandler.checkListReaders(method, step, code);
                break;
            }
            case SCARD_GET_STATUS_CHANGE: {
                LinuxMacosPCSCCallbackHandler.checkGetStatusChange(method, code);
                break;
            }
            case SCARD_CONNECT: {
                LinuxMacosPCSCCallbackHandler.checkConnect(method, code);
                break;
            }
            case SCARD_DISCONNECT: {
                LinuxMacosPCSCCallbackHandler.checkDisconnect(method, code);
                break;
            }
            case SCARD_RECONNECT: {
                LinuxMacosPCSCCallbackHandler.checkReconnect(method, code);
                break;
            }
            case SCARD_CONTROL: {
                LinuxMacosPCSCCallbackHandler.checkControl(method, code);
                break;
            }
            case SCARD_TRANSMIT: {
                LinuxMacosPCSCCallbackHandler.checkTransmit(method, code);
                break;
            }
            case SCARD_STATUS: {
                LinuxMacosPCSCCallbackHandler.checkStatus(method, code);
                break;
            }
            case SCARD_BEGIN_TRANSACTION: {
                LinuxMacosPCSCCallbackHandler.checkBeginTransaction(method, code);
                break;
            }
            case SCARD_END_TRANSACTION: {
                LinuxMacosPCSCCallbackHandler.checkEndTransaction(method, code);
                break;
            }
            case SCARD_CANCEL: {
                LinuxMacosPCSCCallbackHandler.checkCancel(method, code);
                break;
            }
            case SCARD_GET_ATTRIB: {
                LinuxMacosPCSCCallbackHandler.checkGetAttrib(method, code);
                break;
            }
            case SCARD_SET_ATTRIB: {
                LinuxMacosPCSCCallbackHandler.checkSetAttrib(method, code);
                break;
            }
        }
        return null;
    }

    private static void checkEstablishContext(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "establishing context failed";
        switch (code) {
            case -2146435071: 
            case -2146435068: 
            case -2146435066: 
            case -2146435055: 
            case -2146435053: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkReleaseContext(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "releasing context failed";
        switch (code) {
            case -2146435069: 
            case -2146435053: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkIsValidContext(int method, int code) throws PCSCException {
        if (code == -2146435069) {
            return;
        }
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        throw new PCSCException(methodName, "checking context validity, unknown error", -2146435026L, code);
    }

    private static void checkListReaderGroups(int method, int step, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = step == 0 ? "getting length of groups failed" : "getting groups failed";
        switch (code) {
            case -2146435069: 
            case -2146435068: 
            case -2146435066: 
            case -2146435064: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkListReaders(int method, int step, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = step == 0 ? "getting length of readers failed" : "getting readers failed";
        switch (code) {
            case -2146435069: 
            case -2146435068: 
            case -2146435066: 
            case -2146435064: 
            case -2146435043: 
            case -2146435026: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkGetStatusChange(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "getting status change failed";
        switch (code) {
            case -2146435062: {
                return;
            }
            case -2146435069: 
            case -2146435068: 
            case -2146435055: 
            case -2146435049: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkConnect(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "connecting failed";
        switch (code) {
            case -2146435071: 
            case -2146435069: 
            case -2146435068: 
            case -2146435063: 
            case -2146435061: 
            case -2146435060: 
            case -2146435057: 
            case -2146435056: 
            case -2146435055: 
            case -2146435053: 
            case -2146435049: 
            case -2146435043: 
            case -2146435041: 
            case -2146434970: 
            case -2146434969: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkDisconnect(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "disconnecting failed";
        switch (code) {
            case -2146435069: 
            case -2146435060: 
            case -2146435055: 
            case -2146435053: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkReconnect(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "reconnecting failed";
        switch (code) {
            case -2146435071: 
            case -2146435069: 
            case -2146435068: 
            case -2146435063: 
            case -2146435061: 
            case -2146435060: 
            case -2146435057: 
            case -2146435056: 
            case -2146435055: 
            case -2146435053: 
            case -2146435049: 
            case -2146435043: 
            case -2146435041: 
            case -2146434970: 
            case -2146434967: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkControl(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "control operation failed";
        switch (code) {
            case -2146435069: 
            case -2146435068: 
            case -2146435064: 
            case -2146435055: 
            case -2146435053: 
            case -2146435050: 
            case -2146435049: 
            case -2146435043: 
            case -2146435041: 
            case -2146434968: 
            case -2146434967: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkTransmit(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "transmit operation failed";
        switch (code) {
            case -2146435069: 
            case -2146435068: 
            case -2146435064: 
            case -2146435057: 
            case -2146435055: 
            case -2146435053: 
            case -2146435050: 
            case -2146435049: 
            case -2146435043: 
            case -2146434968: 
            case -2146434967: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkStatus(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "status operation failed";
        switch (code) {
            case -2146435071: 
            case -2146435069: 
            case -2146435068: 
            case -2146435066: 
            case -2146435064: 
            case -2146435053: 
            case -2146435049: 
            case -2146435043: 
            case -2146434968: 
            case -2146434967: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkBeginTransaction(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "begin transaction failed";
        switch (code) {
            case -2146435069: 
            case -2146435061: 
            case -2146435053: 
            case -2146435049: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkEndTransaction(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "end transaction failed";
        switch (code) {
            case -2146435069: 
            case -2146435061: 
            case -2146435055: 
            case -2146435053: 
            case -2146435049: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkCancel(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "cancel failed";
        switch (code) {
            case -2146435069: 
            case -2146435053: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkGetAttrib(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "getting attribute failed";
        switch (code) {
            case -2146435069: 
            case -2146435068: 
            case -2146435066: 
            case -2146435064: 
            case -2146435053: 
            case -2146435050: 
            case -2146435049: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    private static void checkSetAttrib(int method, int code) throws PCSCException {
        String methodName = LinuxMacosPCSCCallbackHandler.determineMethodName(method);
        String message = "setting attribute failed";
        switch (code) {
            case -2146435069: 
            case -2146435068: 
            case -2146435064: 
            case -2146435053: 
            case -2146435050: 
            case -2146435049: 
            case -2146435043: {
                throw new PCSCException(methodName, message, code);
            }
        }
        throw new PCSCException(methodName, message + ", unknown error", code);
    }

    static String determineMethodName(int method) {
        return PCSCMethodEnum.values()[method].getName();
    }
}

