/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.callback.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.common.system.VersionEnum;
import de.bos_bremen.jni.NativeException;
import de.bos_bremen.jni.callback.CallbackHandler;
import de.bos_bremen.jni.callback.CallbackHandlerFactory;
import de.bos_bremen.jni.callback.CallbackHandlerFactoryAnnotation;
import de.bos_bremen.jni.callback.CallbackHandlerNotFoundException;
import de.bos_bremen.jni.callback.ContextEnum;
import de.bos_bremen.jni.callback.DefaultCallbackHandler;
import de.bos_bremen.jni.callback.MethodEnum;
import de.bos_bremen.jni.callback.StepEnum;
import de.bos_bremen.jni.callback.Support;
import de.bos_bremen.jni.callback.impl.CTAPICallbackHandler;
import de.bos_bremen.jni.callback.impl.LinuxMacosPCSCCallbackHandler;
import de.bos_bremen.jni.callback.impl.WindowsPCSCCallbackHandler;
import java.util.ArrayList;
import java.util.List;

@CallbackHandlerFactoryAnnotation(value={LinuxMacosPCSCCallbackHandler.class, WindowsPCSCCallbackHandler.class, CTAPICallbackHandler.class, DefaultCallbackHandler.class})
public final class CallbackHandlerFactoryImpl
implements CallbackHandlerFactory {
    private static CallbackHandlerFactoryImpl SINGLETON = null;
    private List<CallbackHandler> handlerList = new ArrayList<CallbackHandler>();
    private SystemEnum system = null;

    @Override
    public SystemEnum getSystem() {
        return this.system;
    }

    private CallbackHandlerFactoryImpl(SystemEnum system) {
        this.system = system;
        if (this.system == null) {
            this.system = SystemEnum.getCurrentSystem();
        }
        this.handlerList = ListUtil.createNewInstanceList(CallbackHandlerFactoryImpl.class.getAnnotation(CallbackHandlerFactoryAnnotation.class).value());
    }

    public void addHandler(Class<? extends CallbackHandler> handlerClass) {
        if (handlerClass != null) {
            ListUtil.addNewInstance(this.handlerList, handlerClass);
        }
    }

    public static CallbackHandlerFactoryImpl getFactory() {
        return CallbackHandlerFactoryImpl.getFactory(null);
    }

    public static CallbackHandlerFactoryImpl getFactory(SystemEnum system) {
        if (SINGLETON == null) {
            SINGLETON = new CallbackHandlerFactoryImpl(system);
        }
        return SINGLETON;
    }

    @Override
    public CallbackHandler getHandler(int version, int context, int method, int step) throws CallbackHandlerNotFoundException {
        Support bestSupport = Support.NOTHING;
        CallbackHandler result = null;
        for (CallbackHandler handler : this.handlerList) {
            Support support = handler.supports(this.system.ordinal(), version, context, method, step);
            if (support == Support.STEP) {
                result = handler;
                break;
            }
            if (support.ordinal() <= bestSupport.ordinal()) continue;
            bestSupport = support;
        }
        if (result != null) {
            return result;
        }
        int lSystem = this.system.ordinal();
        String systemName = this.system.getName();
        if (bestSupport == Support.NOTHING) {
            throw new CallbackHandlerNotFoundException(lSystem, systemName);
        }
        String versionName = VersionEnum.values()[version].getName();
        if (bestSupport == Support.SYSTEM) {
            throw new CallbackHandlerNotFoundException(lSystem, systemName, version, versionName);
        }
        String contextName = ContextEnum.values()[context].getName();
        if (bestSupport == Support.VERSION) {
            throw new CallbackHandlerNotFoundException(lSystem, systemName, version, versionName, context, contextName);
        }
        String methodName = MethodEnum.values()[method].getName();
        if (bestSupport == Support.CONTEXT) {
            throw new CallbackHandlerNotFoundException(lSystem, systemName, version, versionName, context, contextName, method, methodName);
        }
        String stepName = StepEnum.values()[step].getName();
        throw new CallbackHandlerNotFoundException(lSystem, systemName, version, versionName, context, contextName, method, methodName, step, stepName);
    }

    @Override
    public Object evaluate(int version, int context, int method, int step, int code, String message) throws NativeException, CallbackHandlerNotFoundException {
        SystemEnum currentSystem = SystemEnum.getCurrentSystem();
        return this.getHandler(version, context, method, step).evaluate(currentSystem.ordinal(), version, context, method, step, code, message);
    }
}

