/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.callback.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.jni.NativeException;
import de.bos_bremen.jni.callback.AbstractCallbackHandler;
import de.bos_bremen.jni.callback.CTAPIMethodEnum;
import de.bos_bremen.jni.callback.ContextEnum;
import de.bos_bremen.jni.callback.Support;
import de.bos_bremen.jni.ctapi.CTAPIConstants;
import de.bos_bremen.jni.ctapi.CTAPIException;
import de.bos_bremen.jni.ctapi.CTAPIMethodStepsConstants;

public class CTAPICallbackHandler
extends AbstractCallbackHandler
implements CTAPIConstants,
CTAPIMethodStepsConstants {
    private static final int WINDOWS_ERROR_CODE_ERROR_BAD_EXE_FORMAT = 193;
    private static final int WINDOWS_ERROR_CODE_ERROR_CLASS_DOES_NOT_EXIST = 1411;

    public CTAPICallbackHandler() {
        super(ListUtil.combine(ListUtil.toList(new int[]{SystemEnum.LINUX.ordinal(), SystemEnum.MACOS.ordinal()}), SystemEnum.WINDOWS_ALL), Support.ALL_VERSIONS_LIST, ListUtil.toList(new int[]{ContextEnum.CTAPI.ordinal()}), Support.ALL_METHODS_LIST, Support.ALL_STEPS_LIST);
    }

    @Override
    public Object evaluate(int system, int version, int context, int method, int step, int code, String message) throws NativeException {
        if (method == CTAPIMethodEnum.CTAPI_DATA.ordinal()) {
            CTAPICallbackHandler.checkData(code, step, message);
        } else if (method == CTAPIMethodEnum.CTAPI_INIT.ordinal()) {
            CTAPICallbackHandler.checkInit(code, step, message);
        } else if (method == CTAPIMethodEnum.CTAPI_CLOSE.ordinal()) {
            CTAPICallbackHandler.checkClose(code, step, message);
        } else if (method == CTAPIMethodEnum.CTAPI_LOAD_LIBRARY.ordinal()) {
            CTAPICallbackHandler.checkLoadLibrary(code, step, message);
        } else if (method == CTAPIMethodEnum.CTAPI_UNLOAD_LIBRARY.ordinal()) {
            CTAPICallbackHandler.checkUnloadLibrary(code, step, message);
        }
        throw new CTAPIException("unknown method", "unknown step", code, null, message, -1);
    }

    private static void checkLoadLibrary(int code, int step, String message) throws CTAPIException {
        String methodName = "loadLibrary";
        switch (step) {
            case 0: {
                switch (code) {
                    case 2: {
                        throw new CTAPIException(methodName, "library stack full, loading failed", code, null, message, 0);
                    }
                }
                throw new CTAPIException(methodName, "loeading library failed with unknown error caused by stack", code, null, message, 0);
            }
            case 1: {
                switch (code) {
                    case 4: {
                        throw new CTAPIException(methodName, "library name null", code, null, message, 1);
                    }
                    case 8: {
                        throw new CTAPIException(methodName, "library name empty", code, null, message, 1);
                    }
                }
                throw new CTAPIException(methodName, "check library name failed with unknown error", code, null, message, 1);
            }
            case 2: {
                switch (code) {
                    case 16: 
                    case 193: {
                        throw new CTAPIException(methodName, "loading library failed", code, null, message, 2);
                    }
                }
                throw new CTAPIException(methodName, "loading library failed with unknown error", code, null, message, 2);
            }
            case 3: {
                switch (code) {
                    case 32: {
                        throw new CTAPIException(methodName, "loading library successful, no function CT_init found, library unloaded", code, null, message, 3);
                    }
                    case 64: {
                        throw new CTAPIException(methodName, "loading library successful, no function CT_close found, library unloaded", code, null, message, 3);
                    }
                    case 128: {
                        throw new CTAPIException(methodName, "loading library successful, no function CT_data found, library unloaded", code, null, message, 3);
                    }
                }
                throw new CTAPIException(methodName, "loading library successful, function check failed with unknown error", code, null, message, 4);
            }
            case 4: {
                switch (code) {
                    case 2: {
                        throw new CTAPIException(methodName, "library stack full, free location not found", code, null, message, 4);
                    }
                }
                throw new CTAPIException(methodName, "creating handle failed with unknown error", code, null, message, 4);
            }
        }
        throw new CTAPIException(methodName, "unknown step", code, null, message, 4);
    }

    private static void checkUnloadLibrary(int code, int step, String message) throws CTAPIException {
        String methodName = "unloadLibrary";
        switch (step) {
            case 0: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "library handle not valid", code, null, message, 0);
                    }
                    case 1: {
                        throw new CTAPIException(methodName, "invalid library handle", code, null, message, 0);
                    }
                }
                throw new CTAPIException(methodName, "unloading failed with unknown error caused by invalid library handle", code, null, message, 0);
            }
            case 1: {
                switch (code) {
                    case 16384: {
                        throw new CTAPIException(methodName, "unloading failed, not closed initialized connection exists", code, null, message, 1);
                    }
                }
                throw new CTAPIException(methodName, "unloading failed with unknown error caused by existing initialized connection", code, null, message, 1);
            }
            case 2: {
                switch (code) {
                    default: 
                }
                throw new CTAPIException(methodName, "library unloading failed", code, null, message, 2);
            }
        }
    }

    private static void checkInit(int code, int step, String message) throws CTAPIException {
        String methodName = "ctInit";
        switch (step) {
            case 0: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "library handle not valid, value not valid", code, null, message, 0);
                    }
                    case 1: {
                        throw new CTAPIException(methodName, "invalid library handle, handle unknown", code, null, message, 0);
                    }
                }
                throw new CTAPIException(methodName, "init failed with unknown error caused by library handle", code, null, message, 0);
            }
            case 1: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "terminal number not valid", code, null, message, 1);
                    }
                }
                throw new CTAPIException(methodName, "check of terminal number failed with unknown error", code, null, message, 1);
            }
            case 2: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "port not valid", code, null, message, 2);
                    }
                }
                throw new CTAPIException(methodName, "check of port failed with unknown error", code, null, message, 2);
            }
            case 3: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "init failed, invalid parameter", code, null, message, 3);
                    }
                    case -8: {
                        throw new CTAPIException(methodName, "init failed, terminal not correct initialized", code, null, message, 3);
                    }
                    case -10: {
                        throw new CTAPIException(methodName, "init failed, communication with library and/or terminal failed", code, null, message, 3);
                    }
                    case -11: {
                        throw new CTAPIException(methodName, "init failed, internal memory assignment error", code, null, message, 3);
                    }
                    case -127: {
                        throw new CTAPIException(methodName, "init failed, function cancelled by host / operating system", code, null, message, 3);
                    }
                    case -128: {
                        throw new CTAPIException(methodName, "init failed, unknown HTSI error", code, null, message, 3);
                    }
                }
                throw new CTAPIException(methodName, "init failed with unknown error", code, null, message, 3);
            }
        }
    }

    private static void checkData(int code, int step, String message) throws CTAPIException {
        String methodName = "ctData";
        switch (step) {
            case 0: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "library handle not valid, value not valid", code, null, message, 0);
                    }
                    case 1: {
                        throw new CTAPIException(methodName, "invalid library handle, handle unknown", code, null, message, 0);
                    }
                }
                throw new CTAPIException(methodName, "data failed with unknown error caused by library handle", code, null, message, 0);
            }
            case 1: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "invalid terminal number", code, null, message, 1);
                    }
                }
                throw new CTAPIException(methodName, "check of terminal number failed with unknown error", code, null, message, 1);
            }
            case 2: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "invalid source", code, null, message, 2);
                    }
                }
                throw new CTAPIException(methodName, "check of source with unknown error", code, null, message, 2);
            }
            case 3: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "invalid destination", code, null, message, 3);
                    }
                }
                throw new CTAPIException(methodName, "check of destination with unknown error", code, null, message, 3);
            }
            case 4: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "invalid combination of source and destination, destination only permitted as HOST or REMOTE_HOST for given source", code, null, message, 4);
                    }
                }
                throw new CTAPIException(methodName, "check of combination source and destination with unknown error", code, null, message, 4);
            }
            case 5: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "invalid combination of source and destination, source only permitted as HOST or REMOTE_HOST for given destination", code, null, message, 5);
                    }
                }
                throw new CTAPIException(methodName, "check of combination destination and source with unknown error", code, null, message, 5);
            }
            case 6: {
                switch (code) {
                    case 512: {
                        throw new CTAPIException(methodName, "input buffer null", code, null, message, 6);
                    }
                    case 1024: {
                        throw new CTAPIException(methodName, "input buffer empty", code, null, message, 6);
                    }
                    case 4096: {
                        throw new CTAPIException(methodName, "input buffer too large, only 256 bytes permitted", code, null, message, 6);
                    }
                }
                throw new CTAPIException(methodName, "check of input buffer failed with unknown error", code, null, message, 6);
            }
            case 7: {
                switch (code) {
                    case 512: {
                        throw new CTAPIException(methodName, "output buffer null", code, null, message, 7);
                    }
                    case 1024: {
                        throw new CTAPIException(methodName, "output buffer empty", code, null, message, 7);
                    }
                    case 4096: {
                        throw new CTAPIException(methodName, "output buffer too large, only 256 bytes permitted", code, null, message, 7);
                    }
                }
                throw new CTAPIException(methodName, "check of output buffer failed with unknown error", code, null, message, 7);
            }
            case 8: {
                switch (code) {
                    case 8192: {
                        throw new CTAPIException(methodName, "data failed, no initialized connection to terminal", code, null, message, 8);
                    }
                }
                throw new CTAPIException(methodName, "check of initialized connection failed with unknown error", code, null, message, 8);
            }
            case 9: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "data failed, invalid parameter", code, null, message, 9);
                    }
                    case -8: {
                        throw new CTAPIException(methodName, "data failed, terminal not correct initialized", code, null, message, 9);
                    }
                    case -10: {
                        throw new CTAPIException(methodName, "data failed, communication with library and/or terminal failed", code, null, message, 9);
                    }
                    case -11: {
                        throw new CTAPIException(methodName, "data failed, internal memory assignment error", code, null, message, 9);
                    }
                    case -127: {
                        throw new CTAPIException(methodName, "data failed, function cancelled by host / operating system", code, null, message, 9);
                    }
                    case -128: {
                        throw new CTAPIException(methodName, "data failed, unknown HTSI error", code, null, message, 9);
                    }
                }
                throw new CTAPIException(methodName, "data failed with unknown error", code, null, message, 9);
            }
        }
    }

    private static void checkClose(int code, int step, String message) throws CTAPIException {
        String methodName = "ctClose";
        switch (step) {
            case 0: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "library handle not valid, value not valid", code, null, message, 0);
                    }
                    case 1: {
                        throw new CTAPIException(methodName, "invalid library handle, handle unknown", code, null, message, 0);
                    }
                }
                throw new CTAPIException(methodName, "close failed with unknown error caused by library handle", code, null, message, 0);
            }
            case 1: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "invalid terminal number", code, null, message, 1);
                    }
                }
                throw new CTAPIException(methodName, "check of terminal number failed with unknown error", code, null, message, 1);
            }
            case 2: {
                switch (code) {
                    case 8192: {
                        throw new CTAPIException(methodName, "close failed, not initialized connection to terminal", code, null, message, 2);
                    }
                }
                throw new CTAPIException(methodName, "close failed with unknown error caused by missing initialized connection", code, null, message, 2);
            }
            case 3: {
                switch (code) {
                    case -1: {
                        throw new CTAPIException(methodName, "close failed, invalid parameter", code, null, message, 3);
                    }
                    case -8: {
                        throw new CTAPIException(methodName, "close failed, terminal not correct initialized", code, null, message, 3);
                    }
                    case -10: {
                        throw new CTAPIException(methodName, "close failed, communication with library and/or terminal failed", code, null, message, 3);
                    }
                    case -11: {
                        throw new CTAPIException(methodName, "close failed, internal memory assignment error", code, null, message, 3);
                    }
                    case -127: {
                        throw new CTAPIException(methodName, "close failed, function cancelled by host / operating system", code, null, message, 3);
                    }
                    case -128: {
                        throw new CTAPIException(methodName, "close failed, unknown HTSI error", code, null, message, 3);
                    }
                }
                throw new CTAPIException(methodName, "close failed with unknown error", code, null, message, 3);
            }
        }
    }
}

