/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.callback;

public class CallbackHandlerNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String NOT_SUPPORTED_MESSAGE = "not supported";
    private final int system;
    private final String systemName;
    private final int version;
    private final String versionName;
    private final int context;
    private final String contextName;
    private final int method;
    private final String methodName;
    private final int step;
    private final String stepName;

    public CallbackHandlerNotFoundException(int system, String systemName, int version, String versionName, int context, String contextName, int method, String methodName, int step, String stepName) throws IllegalArgumentException {
        super(stepName + " not supported(system: " + systemName + ", version: " + versionName + ", context: " + contextName + ", method: " + methodName + ")");
        CallbackHandlerNotFoundException.checkConstructorArgs("system", system, systemName);
        CallbackHandlerNotFoundException.checkConstructorArgs("version", version, versionName);
        CallbackHandlerNotFoundException.checkConstructorArgs("context", context, contextName);
        CallbackHandlerNotFoundException.checkConstructorArgs("method", method, methodName);
        CallbackHandlerNotFoundException.checkConstructorArgs("step", step, stepName);
        this.system = system;
        this.systemName = systemName;
        this.version = version;
        this.versionName = versionName;
        this.context = context;
        this.contextName = contextName;
        this.method = method;
        this.methodName = methodName;
        this.step = step;
        this.stepName = stepName;
    }

    public CallbackHandlerNotFoundException(int system, String systemName, int version, String versionName, int context, String contextName, int method, String methodName) throws IllegalArgumentException {
        super(methodName + " not supported(system: " + systemName + ", version: " + versionName + ", context: " + contextName + ")");
        CallbackHandlerNotFoundException.checkConstructorArgs("system", system, systemName);
        CallbackHandlerNotFoundException.checkConstructorArgs("version", version, versionName);
        CallbackHandlerNotFoundException.checkConstructorArgs("context", context, contextName);
        CallbackHandlerNotFoundException.checkConstructorArgs("method", method, methodName);
        this.system = system;
        this.systemName = systemName;
        this.version = version;
        this.versionName = versionName;
        this.context = context;
        this.contextName = contextName;
        this.method = method;
        this.methodName = methodName;
        this.step = -1;
        this.stepName = null;
    }

    public CallbackHandlerNotFoundException(int system, String systemName, int version, String versionName, int context, String contextName) throws IllegalArgumentException {
        super(contextName + " not supported(system: " + systemName + ", version: " + versionName + ")");
        CallbackHandlerNotFoundException.checkConstructorArgs("system", system, systemName);
        CallbackHandlerNotFoundException.checkConstructorArgs("version", version, versionName);
        CallbackHandlerNotFoundException.checkConstructorArgs("context", context, contextName);
        this.system = system;
        this.systemName = systemName;
        this.version = version;
        this.versionName = versionName;
        this.context = context;
        this.contextName = contextName;
        this.method = -1;
        this.methodName = null;
        this.step = -1;
        this.stepName = null;
    }

    public CallbackHandlerNotFoundException(int system, String systemName, int version, String versionName) throws IllegalArgumentException {
        super(versionName + " not supported(system: " + systemName + ")");
        CallbackHandlerNotFoundException.checkConstructorArgs("system", system, systemName);
        CallbackHandlerNotFoundException.checkConstructorArgs("version", version, versionName);
        this.system = system;
        this.systemName = systemName;
        this.version = version;
        this.versionName = versionName;
        this.context = -1;
        this.contextName = null;
        this.method = -1;
        this.methodName = null;
        this.step = -1;
        this.stepName = null;
    }

    public CallbackHandlerNotFoundException(int system, String systemName) throws IllegalArgumentException {
        super(systemName + " not supported");
        CallbackHandlerNotFoundException.checkConstructorArgs("system", system, systemName);
        this.system = system;
        this.systemName = systemName;
        this.version = -1;
        this.versionName = null;
        this.context = -1;
        this.contextName = null;
        this.method = -1;
        this.methodName = null;
        this.step = -1;
        this.stepName = null;
    }

    public final int getSystem() {
        return this.system;
    }

    public final String getSystemName() {
        return this.systemName;
    }

    public final int getVersion() {
        return this.version;
    }

    public final String getVersionName() {
        return this.versionName;
    }

    public final int getContext() {
        return this.context;
    }

    public final String getContextName() {
        return this.contextName;
    }

    public final int getMethod() {
        return this.method;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final int getStep() {
        return this.step;
    }

    public final String getStepName() {
        return this.stepName;
    }

    public static void checkConstructorArgs(String checkedInformation, int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(checkedInformation + " expected as value greater equals zero, but was: " + value);
        }
        if (name == null) {
            throw new IllegalArgumentException("name of " + checkedInformation + " not permitted as null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name of " + checkedInformation + " not permitted as empty String");
        }
    }
}

