/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni.callback;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.jni.callback.CallbackHandler;
import de.bos_bremen.jni.callback.Support;
import java.util.List;

public abstract class AbstractCallbackHandler
implements CallbackHandler {
    private List<Integer> supportedSystemList = null;
    private List<Integer> supportedVersionList = null;
    private List<Integer> supportedContextList = null;
    private List<Integer> supportedMethodList = null;
    private List<Integer> supportedStepList = null;

    public AbstractCallbackHandler(List<Integer> supportedSystemList, List<Integer> supportedVersionList, List<Integer> supportedContextList, List<Integer> supportedMethodList, List<Integer> supportedStepList) {
        this.supportedSystemList = ListUtil.createUnmodifableCopy(supportedSystemList);
        this.supportedVersionList = ListUtil.createUnmodifableCopy(supportedVersionList);
        this.supportedContextList = ListUtil.createUnmodifableCopy(supportedContextList);
        this.supportedMethodList = ListUtil.createUnmodifableCopy(supportedMethodList);
        this.supportedStepList = ListUtil.createUnmodifableCopy(supportedStepList);
    }

    @Override
    public final Support supports(int system, int version, int context, int method, int step) {
        Support result = Support.NOTHING;
        if (this.supportedSystemList.contains(0) || this.supportedSystemList.contains(system)) {
            result = Support.SYSTEM;
            if (this.supportedVersionList.contains(0) || this.supportedVersionList.contains(version)) {
                result = Support.VERSION;
                if (this.supportedContextList.contains(0) || this.supportedContextList.contains(context)) {
                    result = Support.CONTEXT;
                    if (this.supportedMethodList.contains(0) || this.supportedMethodList.contains(method)) {
                        result = Support.METHOD;
                        if (this.supportedStepList.contains(0) || this.supportedStepList.contains(step)) {
                            result = Support.STEP;
                        }
                    }
                }
            }
        }
        return result;
    }
}

