/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni;

import de.bos_bremen.jni.JavaSystemBridge;

public final class SystemInfo
extends JavaSystemBridge {
    public static final String INFO_PROCESSOR_TYPE = "ProcessorType";
    public static final String INFO_PROCESSOR_NAME = "ProcessorName";
    public static final String INFO_PROCESSOR_FEATURES = "ProcessorFeatures";
    public static final String INFO_PROCESSOR_L1_CACHE_SIZE = "ProcessorL1CacheSize";
    public static final String INFO_PROCESSOR_L2_CACHE_SIZE = "ProcessorL2CacheSize";
    public static final String INFO_PROCESSOR_CPU_COUNT = "ProcessorCPUCount";
    public static final String INFO_PROCESSOR_CPU_ACTIVE_COUNT = "ProcessorCPUActiveCount";
    public static final String INFO_PROCESSOR_CPU_ACTIVE_BIT_MASK = "ProcessorCPUActiveBitMask";
    public static final String INFO_PROCESSOR_ARCHITECTURE = "ProcessorArchitecture";
    public static final String INFO_PROCESSOR_LEVEL = "ProcessorLevel";
    public static final String INFO_PROCESSOR_REVISION = "ProcessorRevision";
    public static final String INFO_SYSTEM_COMPUTER_NAME = "SystemComputerName";
    public static final String INFO_SYSTEM_USER_NAME = "SystemUserName";
    public static final String INFO_SYSTEM_CURRENT_HW_PROFILE_GUID = "SystemCurrentHWProfileGUID";
    public static final String INFO_SYSTEM_CURRENT_PID = "SystemCurrentPID";

    public static native String getInfo(String var0) throws IllegalArgumentException, UnsupportedOperationException;

    public static void toString(StringBuffer buffer) {
        buffer.append("\n==========================================================================");
        buffer.append("\nSystem informations:");
        String[] infos = new String[]{INFO_PROCESSOR_NAME, INFO_PROCESSOR_FEATURES, INFO_PROCESSOR_L1_CACHE_SIZE, INFO_PROCESSOR_L2_CACHE_SIZE, INFO_PROCESSOR_TYPE, INFO_PROCESSOR_CPU_COUNT, INFO_PROCESSOR_CPU_ACTIVE_COUNT, INFO_PROCESSOR_CPU_ACTIVE_BIT_MASK, INFO_PROCESSOR_ARCHITECTURE, INFO_PROCESSOR_LEVEL, INFO_PROCESSOR_REVISION, INFO_SYSTEM_COMPUTER_NAME, INFO_SYSTEM_USER_NAME, INFO_SYSTEM_CURRENT_HW_PROFILE_GUID, INFO_SYSTEM_CURRENT_PID};
        String details = "";
        for (int i = 0; i < infos.length; ++i) {
            try {
                details = SystemInfo.getInfo(infos[i]);
                if (details == null) continue;
                buffer.append("\n    " + infos[i] + ":    " + details);
                continue;
            }
            catch (IllegalArgumentException e) {
                buffer.append("\n    requested details not found, so also not the following: " + infos[i]);
                continue;
            }
            catch (UnsupportedOperationException e) {
                buffer.append("\n    not supported information: " + infos[i]);
            }
        }
    }

    private SystemInfo() {
    }

    static {
        SystemInfo.loadLibrary();
    }
}

