/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.jni;

import de.bos_bremen.common.StringRepresentable;

public class NativeException
extends Exception
implements StringRepresentable {
    private final Class<?> nativeStepDefinitionClass;
    private final Integer nativeStep;
    private final String nativeMessage;
    private static final long serialVersionUID = 1L;
    private final long code;
    private final String hexCode;
    private final String methodName;
    private final Long systemCode;
    private final String systemHexCode;

    public final Class<?> getNativeStepDefinitionClass() {
        return this.nativeStepDefinitionClass;
    }

    public String getNativeMessage() {
        return this.nativeMessage;
    }

    public Integer getNativeStep() {
        return this.nativeStep;
    }

    public static Long convertCode(Long code) {
        Long result = null;
        if (code == null) {
            return result;
        }
        result = code < 0L ? Long.valueOf((long)((double)code.longValue() + Math.pow(2.0, 32.0))) : code;
        return result;
    }

    public static String convertHexCode(Long code) {
        String result = "";
        if (code == null) {
            return result;
        }
        result = Long.toString(code, 16);
        return result;
    }

    public NativeException() {
        this("", "", -1L, null, null, null, null);
    }

    public NativeException(Class<?> nativeStepDefinitionClass) {
        this("", "", -1L, null, nativeStepDefinitionClass, null, null);
    }

    public NativeException(String methodName, String message, long code) {
        this(methodName, message, code, null, null, null, null);
    }

    public NativeException(String methodName, String message, long code, long systemCode) {
        this(methodName, message, code, systemCode, null, null, null);
    }

    public NativeException(String methodName, String message, long code, Long systemCode) {
        this(methodName, message, code, systemCode, null, null, null);
    }

    public NativeException(String methodName, String message, long code, Long systemCode, Class<?> nativeStepDefinitionClass, String nativeMessage, Integer nativeStep) {
        super(message);
        this.methodName = methodName;
        this.code = code;
        this.hexCode = NativeException.convertHexCode(NativeException.convertCode(this.code));
        if (systemCode != null) {
            this.systemCode = systemCode;
            this.systemHexCode = NativeException.convertHexCode(NativeException.convertCode(this.systemCode));
        } else {
            this.systemCode = null;
            this.systemHexCode = null;
        }
        this.nativeStepDefinitionClass = nativeStepDefinitionClass;
        this.nativeMessage = nativeMessage;
        this.nativeStep = nativeStep;
    }

    public final long getCode() {
        return this.code;
    }

    public final String getHexCode() {
        return this.hexCode;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final Long getSystemCode() {
        return this.systemCode;
    }

    public final String getSystemHexCode() {
        return this.systemHexCode;
    }

    @Override
    public final String toString() {
        return this.getClass().getName() + " (MethodName: " + this.methodName + ", Message: " + super.getMessage() + ", ErrorCode (Hex): " + this.hexCode + ", ErrorCode: " + this.code + (String)(this.systemCode != null ? ", System-ErrorCode (Hex): " + this.systemHexCode + ", System-ErrorCode: " + this.systemCode : "") + (String)(this.nativeMessage != null && this.nativeMessage.length() > 0 ? ", native message: " + this.nativeMessage : "") + (String)(this.nativeStep != null ? ", native step: " + this.nativeStep : "") + (String)(this.nativeStep != null && this.nativeStepDefinitionClass != null ? ", native step defintions at: " + this.nativeStepDefinitionClass.getName() : "") + ")";
    }
}

