/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.java.Support;
import de.bos_bremen.java.pcsc.JPCSCReaderState;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.java.pcsc.impl.AbstractJPCSC;
import de.bos_bremen.jni.pcsc.EnhancedPCSCReaderStateImpl;
import de.bos_bremen.jni.pcsc.PCSC;
import de.bos_bremen.jni.pcsc.PCSCException;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowsJPCSC
extends AbstractJPCSC {
    private static final Log LOG = LogFactory.getLog(WindowsJPCSC.class);

    public WindowsJPCSC() throws IllegalArgumentException {
        super(SystemEnum.WINDOWS_ALL, Support.ALL_VERSIONS_LIST);
    }

    @Override
    public byte[] getAttrib(long cardHandle, int attrID, int timeout) throws PCSCException {
        Semaphore sync = new Semaphore(0);
        GetAttribExecutor executor = new GetAttribExecutor(timeout, sync, cardHandle, attrID);
        AbstractJPCSC.Waiter waiter = new AbstractJPCSC.Waiter(timeout, sync);
        executor.start();
        waiter.run();
        if (!executor.isSuccess()) {
            PCSCException ex = executor.getException();
            throw ex != null ? ex : new PCSCException("SCardGetAttrib", "getAttrib timed out", -1L);
        }
        return executor.getResult();
    }

    @Override
    public void reconnect(long cardHandle, int shareMode, Protocol protocol, int disposition) throws PCSCException {
        super.reconnect(cardHandle, shareMode, protocol, disposition);
        try {
            int newProtocol = PCSC.SCardReconnect(cardHandle, shareMode, protocol.getValue(), disposition);
            protocol.setValue(newProtocol);
        }
        catch (PCSCException e) {
            if (shareMode == 1 && disposition == 1 && e.getCode() == -2146435061L) {
                try {
                    int newProtocol = PCSC.SCardReconnect(cardHandle, 2, protocol.getValue(), 0);
                    protocol.setValue(newProtocol);
                }
                catch (PCSCException e1) {
                    LOG.debug((Object)("reconnect failed: " + e1.getMessage()), (Throwable)e1);
                }
            }
            throw e;
        }
    }

    @Override
    public void beginTransaction(long cardHandle, int timeout) throws PCSCException, IllegalArgumentException {
        block3: {
            super.beginTransaction(cardHandle, timeout);
            EnhancedPCSCReaderStateImpl state = new EnhancedPCSCReaderStateImpl();
            try {
                PCSC.SCardStatus(cardHandle, state);
                if (state.getReaderState() < 5) {
                    throw new PCSCException("SCardBeginTransaction", "warning: card was reset", -2146434968L);
                }
            }
            catch (PCSCException e) {
                if (e.getCode() != -2146434968L) break block3;
                throw new PCSCException("SCardBeginTransaction", "warning: card was reset", -2146434968L);
            }
        }
    }

    @Override
    public void endTransaction(long cardHandle, int dispositionMode) throws PCSCException, IllegalArgumentException {
        block2: {
            try {
                super.endTransaction(cardHandle, dispositionMode);
            }
            catch (PCSCException e) {
                if (e.getCode() == -2146435050L) break block2;
                throw e;
            }
        }
    }

    @Override
    public final synchronized void getStatusChange(long contextHandle, int timeout, JPCSCReaderState[] readerStates) throws PCSCException, IllegalArgumentException {
        super.getStatusChange(contextHandle, timeout, readerStates);
        super.getStatusChange(contextHandle, timeout, readerStates);
    }

    private static class GetAttribExecutor
    extends AbstractJPCSC.AbstractExecutor {
        private long card = 0L;
        private int attrID = 0;
        private byte[] result = null;

        public GetAttribExecutor(int timeout, Semaphore sync, long card, int attrID) {
            super(timeout, sync);
            this.card = card;
            this.attrID = attrID;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            String methodName = "SCardGetAttrib";
            try {
                int resultLength = PCSC.SCardGetAttrib(this.card, this.attrID, this.result);
                if (resultLength <= 0) {
                    this.ex = new PCSCException(methodName, "zero or negative length of attribute", -2146435071L);
                    this.sync.release();
                    return;
                }
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed < (long)this.timeout) {
                    this.result = new byte[resultLength];
                    int resultLength2 = PCSC.SCardGetAttrib(this.card, this.attrID, this.result);
                    if (resultLength != resultLength2) {
                        this.ex = new PCSCException(methodName, "inconsistent length of return", -2146435071L);
                    }
                    this.success = true;
                }
            }
            catch (PCSCException e) {
                this.ex = e;
            }
            this.sync.release();
        }

        public byte[] getResult() {
            return this.result;
        }
    }
}

