/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.java.Support;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.java.pcsc.impl.LinuxMacosJPCSC;
import de.bos_bremen.jni.pcsc.PCSC;
import de.bos_bremen.jni.pcsc.PCSCException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MacJPCSC
extends LinuxMacosJPCSC {
    private static final Log LOG = LogFactory.getLog(MacJPCSC.class);

    public MacJPCSC() throws IllegalArgumentException {
        super(ListUtil.toList(new int[]{SystemEnum.MACOS.ordinal()}), Support.ALL_VERSIONS_LIST);
    }

    @Override
    public void reconnect(long cardHandle, int shareMode, Protocol protocol, int disposition) throws PCSCException {
        super.reconnect(cardHandle, shareMode, protocol, disposition);
        try {
            int newProtocol = PCSC.SCardReconnect(cardHandle, shareMode, protocol.getValue(), disposition);
            protocol.setValue(newProtocol);
        }
        catch (PCSCException e) {
            if (shareMode == 1 && (disposition == 1 || disposition == 2)) {
                try {
                    int newProtocol = PCSC.SCardReconnect(cardHandle, 2, protocol.getValue(), 0);
                    protocol.setValue(newProtocol);
                }
                catch (PCSCException e1) {
                    LOG.debug((Object)("reconnect failed: " + e1.getMessage()), (Throwable)e1);
                }
            }
            throw e;
        }
    }
}

