/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.java.pcsc.impl.MCardDebugSettingConstants;
import org.apache.log4j.Logger;

public enum MCardPcscDebugSetting {
    ALL("mcard.pcsc.debug.all", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_ALL, new MCardPcscDebugSetting[0]),
    MANAGE_ALL("mcard.pcsc.debug.manage.all", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_MANAGE_ALL, ALL),
    MANAGE_CONTEXT("mcard.pcsc.debug.manage.context", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_ALL, MANAGE_ALL),
    MANAGE_CARD("mcard.pcsc.debug.manage.card", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_ALL, MANAGE_ALL),
    READERS("mcard.pcsc.debug.readers", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_READERS, ALL),
    STATUS_ALL("mcard.pcsc.debug.status.all", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_STATUS_ALL, ALL),
    STATUS_READER("mcard.pcsc.debug.status.reader", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_STATUS_READER, STATUS_ALL),
    STATUS_CARD("mcard.pcsc.debug.status.card", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_STATUS_CARD, STATUS_ALL),
    TRANSACTION("mcard.pcsc.debug.transaction", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_TRANSACTION, ALL),
    COM("mcard.pcsc.debug.com", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_COM, ALL),
    TRANSACTION_ENABLED("mcard.pcsc.transaction.enabled", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_TRANSACTION_ENABLED, new MCardPcscDebugSetting[0]),
    TRANSACTION_KEEP_ALIVE_ENABLED("mcard.pcsc.transaction.keepAlive", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_TRANSACTION_KEEP_ALIVE_ENABLED, new MCardPcscDebugSetting[0]),
    TERMINAL_CHANGE_UPDATE("mcard.pcsc.terminal.change.update", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_TERMINAL_CHANGE_UPDATE_ENABLED, new MCardPcscDebugSetting[0]),
    DEBUG("mcard.pcsc.debug.all", MCardDebugSettingConstants.DEFAULT_MCARD_PCSC_DEBUG_ALL, ALL, MANAGE_ALL, MANAGE_CONTEXT, MANAGE_CARD, READERS, STATUS_ALL, STATUS_READER, STATUS_CARD, TRANSACTION, COM);

    private static final Logger LOG;
    private final String property;
    private final Boolean defaultValue;
    private final MCardPcscDebugSetting[] relatedSettings;
    private Boolean currentValue;

    private MCardPcscDebugSetting(String property, Boolean defaultValue, MCardPcscDebugSetting ... relatedSettings) {
        this.property = property;
        this.defaultValue = defaultValue;
        this.relatedSettings = relatedSettings;
    }

    public boolean isEnabled() {
        if (this.currentValue == null) {
            this.currentValue = Boolean.parseBoolean(System.getProperty(this.property, this.defaultValue.toString()));
        }
        if (this.relatedSettings != null) {
            for (MCardPcscDebugSetting relatedSetting : this.relatedSettings) {
                this.currentValue = this.currentValue | relatedSetting.isEnabled();
            }
        }
        return this.currentValue;
    }

    public String getProperty() {
        return this.property;
    }

    boolean isSet() {
        String value = System.getProperty(this.property);
        return value != null && !value.isEmpty();
    }

    void setSystemProperty(Boolean value) {
        if (value == null) {
            this.clear();
            return;
        }
        System.setProperty(this.property, value.toString());
        this.reset();
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public void reset() {
        this.currentValue = null;
    }

    public void flip() {
        this.reset();
        this.isEnabled();
        this.currentValue = this.currentValue == false;
    }

    public void clear() {
        this.reset();
        System.clearProperty(this.property);
    }

    public String toString() {
        return super.toString() + "[property: " + this.property + ", system: " + this.isSet() + ", default value: " + this.defaultValue + ", value: " + this.isEnabled() + "]";
    }

    public static void resetAll() {
        for (MCardPcscDebugSetting value : MCardPcscDebugSetting.values()) {
            value.reset();
        }
    }

    public static void clearAll() {
        for (MCardPcscDebugSetting value : MCardPcscDebugSetting.values()) {
            value.clear();
        }
    }

    public static boolean isPcscDebugEnabled() {
        return DEBUG.isEnabled();
    }

    public static void dumpDebugSettings() {
        StringBuilder sb = new StringBuilder("PC/SC debug settings:\n");
        sb.append("  enabled: " + DEBUG.isEnabled() + "\n");
        sb.append("  all: " + ALL.isEnabled() + "\n");
        sb.append("  manage all: " + MANAGE_ALL.isEnabled() + "\n");
        sb.append("    manage context: " + MANAGE_CONTEXT.isEnabled() + "\n");
        sb.append("    manage card: " + MANAGE_CARD.isEnabled() + "\n");
        sb.append("  list readers: " + READERS.isEnabled() + "\n");
        sb.append("  status all: " + STATUS_ALL.isEnabled() + "\n");
        sb.append("    status reader: " + STATUS_READER.isEnabled() + "\n");
        sb.append("    status card: " + STATUS_CARD.isEnabled() + "\n");
        sb.append("  communication: " + COM.isEnabled() + "\n");
        sb.append("  transsaction: " + TRANSACTION.isEnabled() + "\n");
        sb.append("\n");
        sb.append("  transsactions control: \n");
        sb.append("    enabled: " + TRANSACTION_ENABLED.isEnabled() + "\n");
        sb.append("    keep alive enabled: " + TRANSACTION_KEEP_ALIVE_ENABLED.isEnabled() + "\n");
        sb.append("\n");
        sb.append("  terminal changes: \n");
        sb.append("    update: " + TERMINAL_CHANGE_UPDATE.isEnabled() + "\n");
        LOG.info((Object)sb.toString());
        System.out.println(sb.toString());
    }

    static {
        LOG = Logger.getLogger(MCardPcscDebugSetting.class);
    }
}

