/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.java.Support;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.java.pcsc.impl.AbstractJPCSC;
import de.bos_bremen.jni.pcsc.PCSC;
import de.bos_bremen.jni.pcsc.PCSCException;
import java.util.List;

public class LinuxMacosJPCSC
extends AbstractJPCSC {
    public LinuxMacosJPCSC(List<Integer> supportedSystemList, List<Integer> supportedVersionList) throws IllegalArgumentException {
        super(supportedSystemList, supportedVersionList);
    }

    public LinuxMacosJPCSC() throws IllegalArgumentException {
        super(ListUtil.toList(new int[]{SystemEnum.LINUX.ordinal()}), Support.ALL_VERSIONS_LIST);
    }

    @Override
    public byte[] getAttrib(long cardHandle, int attrID, int timeout) throws PCSCException {
        String methodName = "SCardGetAttrib";
        byte[] buffer = null;
        int resultLength = PCSC.SCardGetAttrib(cardHandle, attrID, null);
        if (resultLength > 0) {
            buffer = new byte[resultLength];
            int resultLength2 = PCSC.SCardGetAttrib(cardHandle, attrID, buffer);
            if (resultLength != resultLength2) {
                throw new PCSCException("SCardGetAttrib", "inconsistent length of return", -2146435071L);
            }
        } else {
            throw new PCSCException("SCardGetAttrib", "zero or negative length of attribute", -2146435071L);
        }
        return buffer;
    }

    @Override
    public void reconnect(long cardHandle, int shareMode, Protocol protocol, int disposition) throws PCSCException, IllegalArgumentException {
        super.reconnect(cardHandle, shareMode, protocol, disposition);
        int newProtocol = PCSC.SCardReconnect(cardHandle, shareMode, protocol.getValue(), disposition);
        protocol.setValue(newProtocol);
    }
}

