/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.java.pcsc.EnhancedJPCSCReaderState;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.java.pcsc.ReaderStateLeveler;
import de.bos_bremen.java.pcsc.impl.WindowsStateLeveler;
import de.bos_bremen.jni.pcsc.EnhancedPCSCReaderStateImpl;

public class EnhancedJPCSCReaderStateImpl
extends EnhancedPCSCReaderStateImpl
implements EnhancedJPCSCReaderState {
    public static final ReaderStateLeveler DEFAULT_LEVELER = s -> s;
    private ReaderStateLeveler leveler = DEFAULT_LEVELER;
    private Protocol protocol = null;
    private int shareMode = -1;

    public EnhancedJPCSCReaderStateImpl(String name, int readerState, int currentState, int eventState, byte[] atr, int protocol) {
        super(name, readerState, currentState, eventState, atr, protocol);
        this.protocol = new Protocol(protocol);
    }

    public EnhancedJPCSCReaderStateImpl(String name, Object applicationData, int readerState, int currentState, int eventState, byte[] atr, int protocol) {
        super(name, applicationData, readerState, currentState, eventState, atr, protocol);
        this.protocol = new Protocol(protocol);
        if (SystemEnum.WINDOWS_ALL.contains(SystemEnum.getCurrentSystem().ordinal())) {
            this.leveler = new WindowsStateLeveler();
        }
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public synchronized void setProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol not permitted as null");
        }
        this.protocol = protocol;
        super.setProtocolValue(this.protocol.getValue());
    }

    @Override
    public int getLeveledReaderState() {
        return this.leveler.toLeveledState(this.getReaderState());
    }

    @Override
    public ReaderStateLeveler getReaderStateLeveler() {
        return this.leveler;
    }

    @Override
    public void setReaderStateLeveler(ReaderStateLeveler newLeveler) {
        this.leveler = newLeveler == null ? DEFAULT_LEVELER : newLeveler;
    }

    @Override
    public int getSharingMode() {
        return this.shareMode;
    }

    @Override
    public void setSharingMode(int mode) {
        if (mode != 3 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("unknown/unsupported sharing mode: " + mode);
        }
        this.shareMode = mode;
    }
}

