/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.java.Support;
import de.bos_bremen.java.pcsc.EnhancedJPCSCReaderState;
import de.bos_bremen.java.pcsc.JPCSC;
import de.bos_bremen.java.pcsc.JPCSCReaderState;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.java.pcsc.impl.MCardPcscDebugSetting;
import de.bos_bremen.jni.pcsc.PCSCException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DebugJPCSC
implements JPCSC {
    private static final Logger LOG = Logger.getLogger(DebugJPCSC.class);
    private final JPCSC jpcsc;
    private String prefix;

    public DebugJPCSC(JPCSC jpcsc) {
        this.jpcsc = jpcsc;
        this.prefix = this + "-mcard.pcsc.";
    }

    public static boolean isPcscTransactionEnabled() {
        return MCardPcscDebugSetting.TRANSACTION_ENABLED.isEnabled();
    }

    public static boolean isPcscTransactionKeepAliveEnabled() {
        return MCardPcscDebugSetting.TRANSACTION_KEEP_ALIVE_ENABLED.isEnabled();
    }

    static JPCSC getJPCSC(JPCSC jpcsc) {
        if (MCardPcscDebugSetting.isPcscDebugEnabled()) {
            return new DebugJPCSC(jpcsc);
        }
        return jpcsc;
    }

    public static boolean isPcscDebugAllEnabled() {
        return MCardPcscDebugSetting.ALL.isEnabled();
    }

    public static boolean isPcscDebugManageAllEnabled() {
        return MCardPcscDebugSetting.MANAGE_ALL.isEnabled();
    }

    public static boolean isPcscDebugManageContextEnabled() {
        return MCardPcscDebugSetting.MANAGE_CONTEXT.isEnabled();
    }

    public static boolean isPcscDebugManageCardEnabled() {
        return MCardPcscDebugSetting.MANAGE_CARD.isEnabled();
    }

    public static boolean isPcscDebugReadersEnabled() {
        return MCardPcscDebugSetting.READERS.isEnabled();
    }

    public static boolean isPcscDebugStatusAllEnabled() {
        return MCardPcscDebugSetting.STATUS_ALL.isEnabled();
    }

    public static boolean isPcscDebugStatusReaderEnabled() {
        return MCardPcscDebugSetting.STATUS_READER.isEnabled();
    }

    public static boolean isPcscDebugStatusCardEnabled() {
        return MCardPcscDebugSetting.STATUS_CARD.isEnabled();
    }

    public static boolean isPcscDebugTransactionEnabled() {
        return MCardPcscDebugSetting.TRANSACTION.isEnabled();
    }

    public static boolean isPcscDebugComEnabled() {
        return MCardPcscDebugSetting.COM.isEnabled();
    }

    @Override
    public Support supports(int system, int version) {
        return this.jpcsc.supports(system, version);
    }

    @Override
    public PCSCException mapThrowable(int mode, PCSCException cause) {
        return this.jpcsc.mapThrowable(mode, cause);
    }

    @Override
    public long establishContext(int scope, Object pvReserved1, Object pvReserved2) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "establishContext (before) - scope: " + scope + ", pvReserved1: " + pvReserved1 + ", pvReserved2: " + pvReserved2));
        }
        long contextHandle = this.jpcsc.establishContext(scope, pvReserved1, pvReserved2);
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "establishContext (after) - scope: " + scope + ", pvReserved1: " + pvReserved1 + ", pvReserved2: " + pvReserved2 + " -> contextHandle: " + contextHandle));
        }
        return contextHandle;
    }

    @Override
    public void releaseContext(long contextHandle) throws PCSCException {
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "releaseContext (before) - contextHandle: " + contextHandle));
        }
        this.jpcsc.releaseContext(contextHandle);
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "releaseContext (after) - contextHandle: " + contextHandle));
        }
    }

    @Override
    public boolean isValidContext(long contextHandle) throws PCSCException {
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "isValidContext (before) - contextHandle: " + contextHandle));
        }
        boolean valid = this.jpcsc.isValidContext(contextHandle);
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "isValidContext (after) - contextHandle: " + contextHandle + " -> valid: " + valid));
        }
        return valid;
    }

    @Override
    public String[] listReaderGroups(long contextHandle) throws PCSCException {
        if (DebugJPCSC.isPcscDebugReadersEnabled()) {
            LOG.info((Object)(this.prefix + "listReaderGroups (before) - contextHandle: " + contextHandle));
        }
        String[] readerGroups = this.jpcsc.listReaderGroups(contextHandle);
        if (DebugJPCSC.isPcscDebugReadersEnabled()) {
            LOG.info((Object)(this.prefix + "listReaderGroups (after) - contextHandle: " + contextHandle + " -> reader groups: " + (readerGroups != null && readerGroups.length > 0 ? Arrays.asList(readerGroups) : "- no reader groups-")));
        }
        return readerGroups;
    }

    @Override
    public String[] listReaders(long contextHandle, String[] readerGroups) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugReadersEnabled()) {
            LOG.info((Object)(this.prefix + "listReaders (before) - contextHandle:" + contextHandle + ", readerGroups: " + (readerGroups != null && readerGroups.length > 0 ? Arrays.asList(readerGroups) : "- no reader groups-")));
        }
        String[] readers = this.jpcsc.listReaders(contextHandle, readerGroups);
        if (DebugJPCSC.isPcscDebugReadersEnabled()) {
            LOG.info((Object)(this.prefix + "listReaders (after) - contextHandle:" + contextHandle + ", readerGroups: " + (readerGroups != null && readerGroups.length > 0 ? Arrays.asList(readerGroups) : "- no reader groups-") + " -> readers: " + (readers != null && readers.length > 0 ? Arrays.asList(readers) : "- no readers-")));
        }
        return readers;
    }

    @Override
    public void status(long cardHandle, EnhancedJPCSCReaderState readerState) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugStatusCardEnabled()) {
            LOG.info((Object)(this.prefix + "status (before) - cardHandle: " + cardHandle + ", reader: " + readerState.getName()));
        }
        this.jpcsc.status(cardHandle, readerState);
        if (DebugJPCSC.isPcscDebugStatusCardEnabled()) {
            LOG.info((Object)(this.prefix + "status (before) - cardHandle: " + cardHandle + ", reader: " + readerState.getName() + " -> event state: " + readerState.getEventState() + ", reader state: " + readerState.getReaderState() + ", current state: " + readerState.getCurrentState()));
        }
    }

    @Override
    public void status(long cardHandle, EnhancedJPCSCReaderState readerState, int timeout) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugStatusCardEnabled()) {
            LOG.info((Object)(this.prefix + "status (before) - cardHandle: " + cardHandle + ", reader: " + readerState.getName() + ", timeout: " + timeout));
        }
        this.jpcsc.status(cardHandle, readerState, timeout);
        if (DebugJPCSC.isPcscDebugStatusCardEnabled()) {
            LOG.info((Object)(this.prefix + "status (before) - cardHandle: " + cardHandle + ", reader: " + readerState.getName() + ", timeout: " + timeout + " -> event state: " + readerState.getEventState() + ", reader state: " + readerState.getReaderState() + ", current state: " + readerState.getCurrentState()));
        }
    }

    @Override
    public void getStatusChange(long contextHandle, int timeout, JPCSCReaderState[] readerStates) throws PCSCException, IllegalArgumentException {
        StringBuilder readerNames = new StringBuilder();
        if (DebugJPCSC.isPcscDebugStatusReaderEnabled()) {
            if (readerStates != null && readerStates.length > 0) {
                for (JPCSCReaderState readerState : readerStates) {
                    readerNames.append(readerState.getName() + "\n");
                }
            }
            LOG.info((Object)(this.prefix + "getStatusChange (before) - contextHandle: " + contextHandle + ", timeout: " + timeout + ", readers\n " + readerNames));
        }
        this.jpcsc.getStatusChange(contextHandle, timeout, readerStates);
        if (DebugJPCSC.isPcscDebugStatusReaderEnabled()) {
            LOG.info((Object)(this.prefix + "getStatusChange (after) - contextHandle: " + contextHandle + ", timeout: " + timeout + ", readers\n " + readerNames));
        }
    }

    @Override
    public long connect(long contextHandle, String reader, int shareMode, Protocol protocol) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "connect (before) - contextHandle: " + contextHandle + ", reader: " + reader + ", shareMode: " + shareMode + ", protocol: " + this.toProtocolValue(protocol)));
        }
        long cardHandle = this.jpcsc.connect(contextHandle, reader, shareMode, protocol);
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "connect (after) - contextHandle: " + contextHandle + ", reader: " + reader + ", shareMode: " + shareMode + ", protocol: " + this.toProtocolValue(protocol) + " -> cardHandle: " + cardHandle));
        }
        return cardHandle;
    }

    private String toProtocolValue(Protocol protocol) {
        return protocol != null ? "T=" + (protocol.getValue() - 1) : "- no protocol -";
    }

    @Override
    public long connect(long contextHandle, String reader, int shareMode, Protocol protocol, int timeout) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "connect (before) - contextHandle: " + contextHandle + ", reader: " + reader + ", shareMode: " + shareMode + ", protocol: " + this.toProtocolValue(protocol) + ", timeout: " + timeout));
        }
        long cardHandle = this.jpcsc.connect(contextHandle, reader, shareMode, protocol, timeout);
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "connect (after) - contextHandle: " + contextHandle + ", reader: " + reader + ", shareMode: " + shareMode + ", protocol: " + this.toProtocolValue(protocol) + ", timeout: " + timeout + " -> cardHandle: " + cardHandle));
        }
        return cardHandle;
    }

    @Override
    public void disconnect(long cardHandle, int dispositionMode) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "disconnect (before) - cardHandle: " + cardHandle + ", disposition: " + dispositionMode));
        }
        this.jpcsc.disconnect(cardHandle, dispositionMode);
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "disconnect (after) - cardHandle: " + cardHandle + ", disposition: " + dispositionMode));
        }
    }

    @Override
    public void disconnect(long cardHandle, int dispositionMode, int timeout) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "disconnect (before) - cardHandle: " + cardHandle + ", disposition: " + dispositionMode + ", timeout: " + timeout));
        }
        this.jpcsc.disconnect(cardHandle, dispositionMode, timeout);
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "disconnect (after) - cardHandle: " + cardHandle + ", disposition: " + dispositionMode + ", timeout: " + timeout));
        }
    }

    @Override
    public void reconnect(long cardHandle, int shareMode, Protocol protocol, int dispositionMode) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "reconnect (before) - cardHandle: " + cardHandle + ", shareMode: " + shareMode + ", protocol: " + this.toProtocolValue(protocol) + ", dispostionMode: " + dispositionMode));
        }
        this.jpcsc.reconnect(cardHandle, shareMode, protocol, dispositionMode);
        if (DebugJPCSC.isPcscDebugManageCardEnabled()) {
            LOG.info((Object)(this.prefix + "reconnect (after) - cardHandle: " + cardHandle + ", shareMode: " + shareMode + ", protocol: " + this.toProtocolValue(protocol) + ", dispostionMode: " + dispositionMode));
        }
    }

    @Override
    public byte[] control(long cardHandle, int controlCode, byte[] sendBuffer, int responseBufferSize) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugComEnabled()) {
            LOG.info((Object)(this.prefix + "control (before) - cardHandle: " + cardHandle + ", control code: " + controlCode));
        }
        byte[] response = this.jpcsc.control(cardHandle, controlCode, sendBuffer, responseBufferSize);
        if (DebugJPCSC.isPcscDebugComEnabled()) {
            LOG.info((Object)(this.prefix + "control (after) - cardHandle: " + cardHandle + ", control code: " + controlCode + " -> response: " + this.toResponseValue(response)));
        }
        return response;
    }

    private String toResponseValue(byte[] response) {
        return response == null || response.length == 0 ? "- no response -" : String.valueOf(response.length);
    }

    @Override
    public byte[] transmit(long cardHandle, Protocol protocol, byte[] sendBuffer, int responseBufferSize) throws PCSCException, IllegalArgumentException {
        if (DebugJPCSC.isPcscDebugComEnabled()) {
            LOG.info((Object)(this.prefix + "control (before) - cardHandle: " + cardHandle + ", protocol: " + this.toProtocolValue(protocol)));
        }
        byte[] response = this.jpcsc.transmit(cardHandle, protocol, sendBuffer, responseBufferSize);
        if (DebugJPCSC.isPcscDebugComEnabled()) {
            LOG.info((Object)(this.prefix + "control (after) - cardHandle: " + cardHandle + ", protocol: " + this.toProtocolValue(protocol) + " -> response: " + this.toResponseValue(response)));
        }
        return response;
    }

    @Override
    public void beginTransaction(long cardHandle) throws PCSCException {
        if (!DebugJPCSC.isPcscTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "beginTransaction - attention, security leak: transactions are disabled"));
            return;
        }
        LOG.info((Object)(this.prefix + "beginTransaction (before) - cardHandle: " + cardHandle));
        this.jpcsc.beginTransaction(cardHandle);
        LOG.info((Object)(this.prefix + "beginTransaction (after) - cardHandle: " + cardHandle));
    }

    @Override
    public void beginTransaction(long cardHandle, int timeout) throws PCSCException, IllegalArgumentException {
        if (!DebugJPCSC.isPcscTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "beginTransaction - attention, security leak: transactions are disabled"));
            return;
        }
        if (DebugJPCSC.isPcscDebugTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "beginTransaction (before) - cardHandle: " + cardHandle + ", timeout: " + timeout));
        }
        this.jpcsc.beginTransaction(cardHandle, timeout);
        if (DebugJPCSC.isPcscDebugTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "beginTransaction (after) - cardHandle : " + cardHandle + ", timeout: " + timeout));
        }
    }

    @Override
    public void endTransaction(long cardHandle, int dispositionMode) throws PCSCException, IllegalArgumentException {
        if (!DebugJPCSC.isPcscTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "endTransaction - attention, security leak: transactions are disabled"));
            return;
        }
        if (DebugJPCSC.isPcscDebugTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "endTransaction (before) - cardHandle: " + cardHandle + ", dispostionMode: " + dispositionMode));
        }
        this.jpcsc.endTransaction(cardHandle, dispositionMode);
        if (DebugJPCSC.isPcscDebugTransactionEnabled()) {
            LOG.info((Object)(this.prefix + "endTransaction (after) - cardHandle: " + cardHandle + ", dispostionMode: " + dispositionMode));
        }
    }

    @Override
    public void cancel(long contextHandle) throws PCSCException {
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "cancel (before) - contextHandle: " + contextHandle));
        }
        this.jpcsc.cancel(contextHandle);
        if (DebugJPCSC.isPcscDebugManageContextEnabled()) {
            LOG.info((Object)(this.prefix + "cancel (after) - contextHandle: " + contextHandle));
        }
    }

    @Override
    public byte[] getAttrib(long cardHandle, int attrID) throws PCSCException {
        return this.jpcsc.getAttrib(cardHandle, attrID);
    }

    @Override
    public byte[] getAttrib(long cardHandle, int attrID, int timeout) throws PCSCException {
        return this.jpcsc.getAttrib(cardHandle, attrID, timeout);
    }

    @Override
    public void setAttrib(long cardHandle, int attrID, byte[] attrValue) throws PCSCException, IllegalArgumentException {
        this.jpcsc.setAttrib(cardHandle, attrID, attrValue);
    }
}

